#
# Copyright (c) 2019. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#

from org.apache.http.client import ClientProtocolException

from sonar import SonarApiService

global configuration

params = {
    'url': configuration.url,
    'username': configuration.username,
    'password': configuration.password,
    'userToken': configuration.userToken,
    'proxyHost': configuration.proxyHost,
    'proxyPort': configuration.proxyPort,
    'proxyUsername': configuration.proxyUsername,
    'proxyPassword': configuration.proxyPassword,
    'proxyDomain': configuration.proxyDomain,
    'authenticationMethod': configuration.authenticationMethod
}

path = configuration.checkConfigurationPath
contentType = None

response = None
try:
    response = SonarApiService.get_http_request(params).get(path, contentType=contentType)
except ClientProtocolException:
    raise Exception("URL is not valid")

if not response.isSuccessful():
    reason = "Unknown"
    if response.status == 400:
        reason = "Bad request"
    elif response.status == 401:
        reason = "Unauthorized"
    elif response.status == 403:
        reason = "Forbidden"
    raise Exception("HTTP response code %s (%s)" % (response.status, reason))
