#
# Copyright (c) 2023. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#
import tempfile
from opa.parseAppwareJsonLog import AppwareJsonParser

print("Downloading logs from Jenkins build")

from jenkins import JenkinsServer

CONTENT_TYPE = 'application/json'
jenkinsURL = jenkinsServer['url']

jobUrl = jobUrl.replace(jenkinsURL, '')
jobContext = jobUrl + '/consoleText'

jenkins = JenkinsServer(jenkinsServer, username, password, apiToken)
request = jenkins.create_request()
headers = jenkins.create_api_token_header(request)

response = request.get(jobContext, contentType=CONTENT_TYPE, headers=headers)

if response.isSuccessful():
    tmp = tempfile.NamedTemporaryFile(suffix='.txt')
    with open(tmp.name, 'w') as f:
        f.write(response.getResponse())
    logPath = tmp.name
    print("Downloaded logs to %s" % logPath)
else:
    raise Exception("Download logs failed with status %s (%s)" % (response.status, response.getResponse()))


jsonInput = AppwareJsonParser(logPath).parse()
