/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.activity;

import com.google.common.base.Objects;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.xlrelease.activity.DefaultTaskFieldsComparator;
import com.xebialabs.xlrelease.activity.TaskFieldsComparator;
import com.xebialabs.xlrelease.domain.ActivityLogEntry;
import com.xebialabs.xlrelease.domain.CustomScriptTask;
import com.xebialabs.xlrelease.domain.PythonScript;
import com.xebialabs.xlrelease.domain.ReleaseActivity;
import com.xebialabs.xlrelease.domain.Task;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CustomScriptTaskFieldsComparator
implements TaskFieldsComparator<CustomScriptTask> {
    private DefaultTaskFieldsComparator defaultTaskFieldsComparator;

    @Autowired
    public CustomScriptTaskFieldsComparator(DefaultTaskFieldsComparator defaultTaskFieldsComparator) {
        this.defaultTaskFieldsComparator = defaultTaskFieldsComparator;
    }

    @Override
    public Class<CustomScriptTask> getTaskClass() {
        return CustomScriptTask.class;
    }

    @Override
    public List<ActivityLogEntry> getLogs(Date timestamp, String username, CustomScriptTask original, CustomScriptTask updated) {
        String propertyName;
        List<ActivityLogEntry> updateLogs = this.defaultTaskFieldsComparator.getLogs(timestamp, username, (Task)original, (Task)updated);
        PythonScript pythonScript = original.getPythonScript();
        PythonScript updatedPythonScript = updated.getPythonScript();
        for (PropertyDescriptor propertyDescriptor : pythonScript.getInputProperties()) {
            propertyName = propertyDescriptor.getName();
            if (propertyDescriptor.isPassword()) {
                this.comparePasswordProperty(timestamp, username, updateLogs, (Task)updated, pythonScript, propertyDescriptor, propertyName);
                continue;
            }
            this.compareProperty(timestamp, username, updateLogs, (Task)updated, pythonScript, propertyDescriptor, propertyName);
        }
        for (PropertyDescriptor propertyDescriptor : pythonScript.getOutputProperties()) {
            Object newValue;
            propertyName = propertyDescriptor.getName();
            Object oldValue = pythonScript.getProperty(propertyName);
            if (Objects.equal((Object)oldValue, (Object)(newValue = updatedPythonScript.getProperty(propertyName)))) continue;
            updateLogs.add(ReleaseActivity.TASK_OUTPUT_PROPERTIES_UPDATED.create(timestamp, username, original.getType(), original.getId(), updated.getTitle(), propertyDescriptor.getLabel(), oldValue, newValue));
        }
        return updateLogs;
    }

    private void comparePasswordProperty(Date timestamp, String username, List<ActivityLogEntry> logEntries2, Task updated, PythonScript pythonScript, PropertyDescriptor propertyDescriptor, String propertyName) {
        Object newValue;
        Object oldValue = pythonScript.getProperty(propertyName);
        if (!Objects.equal((Object)oldValue, (Object)(newValue = ((CustomScriptTask)updated).getPythonScript().getProperty(propertyName)))) {
            logEntries2.add(ReleaseActivity.TASK_INPUT_PROPERTY_PASSWORD_UPDATED.create(timestamp, username, updated.getType(), updated.getId(), updated.getTitle(), propertyDescriptor.getLabel()));
        }
    }

    private void compareProperty(Date timestamp, String username, List<ActivityLogEntry> logEntries2, Task updated, PythonScript pythonScript, PropertyDescriptor propertyDescriptor, String propertyName) {
        Object newValue;
        Object oldValue = pythonScript.getProperty(propertyName);
        if (!Objects.equal((Object)oldValue, (Object)(newValue = ((CustomScriptTask)updated).getPythonScript().getProperty(propertyName)))) {
            logEntries2.add(ReleaseActivity.TASK_INPUT_PROPERTY_UPDATED.create(timestamp, username, updated.getType(), updated.getId(), updated.getTitle(), propertyDescriptor.getLabel(), oldValue, newValue));
        }
    }
}

