/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar.ptql;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.hyperic.sigar.ptql.MalformedQueryException;
import org.hyperic.sigar.ptql.ProcessQuery;
import org.hyperic.sigar.ptql.SigarProcessQuery;

public class ProcessQueryFactory {
    private static ProcessQueryFactory instance = null;
    private Map cache = new HashMap();

    public void clear() {
        Iterator it = this.cache.values().iterator();
        while (it.hasNext()) {
            SigarProcessQuery query = (SigarProcessQuery)it.next();
            query.destroy();
        }
        this.cache.clear();
    }

    public static ProcessQueryFactory getInstance() {
        if (instance == null) {
            instance = new ProcessQueryFactory();
        }
        return instance;
    }

    public ProcessQuery getQuery(String query) throws MalformedQueryException {
        if (query == null) {
            throw new MalformedQueryException("null query");
        }
        if (query.length() == 0) {
            throw new MalformedQueryException("empty query");
        }
        ProcessQuery pQuery = (ProcessQuery)this.cache.get(query);
        if (pQuery != null) {
            return pQuery;
        }
        pQuery = new SigarProcessQuery();
        ((SigarProcessQuery)pQuery).create(query);
        this.cache.put(query, pQuery);
        return pQuery;
    }

    public static ProcessQuery getInstance(String query) throws MalformedQueryException {
        return ProcessQueryFactory.getInstance().getQuery(query);
    }
}

