/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.spring;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import com.xebialabs.deployit.spring.HoconConfigPropertySource;
import java.io.IOException;
import java.io.Reader;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.support.EncodedResource;
import org.springframework.core.io.support.PropertySourceFactory;
import org.springframework.util.StringUtils;

public class HoconPropertySourceFactory
implements PropertySourceFactory {
    protected String getName(Config config) {
        if (config.origin().filename() != null) {
            return config.origin().filename();
        }
        if (config.origin().resource() != null) {
            return config.origin().resource();
        }
        if (config.origin().url() != null) {
            return config.origin().url().toString();
        }
        try {
            return config.origin().description();
        }
        catch (Exception e) {
            return "typeSafe";
        }
    }

    public PropertySource<?> createPropertySource(String name, EncodedResource resource) throws IOException {
        Config config = ConfigFactory.parseReader((Reader)resource.getReader()).withFallback((ConfigMergeable)ConfigFactory.defaultReference()).resolve();
        String safeName = StringUtils.isEmpty((Object)name) ? this.getName(config) : name;
        return new HoconConfigPropertySource(safeName, config);
    }
}

