/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.bdio.graph.builder;

import com.synopsys.integration.bdio.graph.DependencyGraph;
import com.synopsys.integration.bdio.graph.MutableMapDependencyGraph;
import com.synopsys.integration.bdio.graph.builder.LazyBuilderMissingExternalIdHandler;
import com.synopsys.integration.bdio.graph.builder.MissingExternalIdException;
import com.synopsys.integration.bdio.model.dependency.Dependency;
import com.synopsys.integration.bdio.model.dependencyid.DependencyId;
import com.synopsys.integration.bdio.model.externalid.ExternalId;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class LazyExternalIdDependencyGraphBuilder {
    private final Set<DependencyId> rootDependencyIds = new HashSet<DependencyId>();
    private final Map<DependencyId, LazyDependencyInfo> dependencyInfo = new HashMap<DependencyId, LazyDependencyInfo>();

    private LazyDependencyInfo infoForId(DependencyId id) {
        LazyDependencyInfo info = this.dependencyInfo.get(id);
        if (info.getAliasId() != null) {
            info = this.dependencyInfo.get(info.getAliasId());
        }
        return info;
    }

    public DependencyGraph build() throws MissingExternalIdException {
        return this.build((dependencyId, lazyDependencyInfo) -> {
            if (lazyDependencyInfo != null && lazyDependencyInfo.aliasId != null) {
                throw new MissingExternalIdException(lazyDependencyInfo.aliasId);
            }
            throw new MissingExternalIdException(dependencyId);
        });
    }

    public DependencyGraph build(LazyBuilderMissingExternalIdHandler lazyBuilderHandler) throws MissingExternalIdException {
        LazyDependencyInfo lazyDependencyInfo;
        MutableMapDependencyGraph mutableDependencyGraph = new MutableMapDependencyGraph();
        for (DependencyId dependencyId : this.dependencyInfo.keySet()) {
            lazyDependencyInfo = this.infoForId(dependencyId);
            if (lazyDependencyInfo.getExternalId() != null) continue;
            ExternalId handledExternalId = lazyBuilderHandler.handleMissingExternalId(dependencyId, lazyDependencyInfo);
            if (handledExternalId == null || dependencyId == null) {
                throw new MissingExternalIdException(dependencyId);
            }
            lazyDependencyInfo.setExternalId(handledExternalId);
        }
        for (DependencyId dependencyId : this.dependencyInfo.keySet()) {
            lazyDependencyInfo = this.infoForId(dependencyId);
            Dependency dependency = new Dependency(lazyDependencyInfo.getName(), lazyDependencyInfo.getVersion(), lazyDependencyInfo.getExternalId());
            for (DependencyId child : lazyDependencyInfo.getChildren()) {
                LazyDependencyInfo childInfo = this.infoForId(child);
                mutableDependencyGraph.addParentWithChild(dependency, new Dependency(childInfo.getName(), childInfo.getVersion(), childInfo.getExternalId()));
            }
            if (!this.rootDependencyIds.contains(dependencyId) && !this.rootDependencyIds.contains(lazyDependencyInfo.getAliasId())) continue;
            mutableDependencyGraph.addChildToRoot(dependency);
        }
        return mutableDependencyGraph;
    }

    private void ensureDependencyInfoExists(DependencyId dependencyId) {
        if (!this.dependencyInfo.containsKey(dependencyId)) {
            this.dependencyInfo.put(dependencyId, new LazyDependencyInfo());
        }
    }

    public void setDependencyAsAlias(DependencyId realDependencyId, DependencyId fakeDependencyId) {
        this.ensureDependencyInfoExists(realDependencyId);
        this.ensureDependencyInfoExists(fakeDependencyId);
        LazyDependencyInfo info = this.dependencyInfo.get(fakeDependencyId);
        info.setAliasId(realDependencyId);
    }

    public void setDependencyInfo(DependencyId id, String name, String version, ExternalId externalId) {
        this.ensureDependencyInfoExists(id);
        LazyDependencyInfo info = this.dependencyInfo.get(id);
        info.setName(name);
        info.setVersion(version);
        info.setExternalId(externalId);
    }

    public void setDependencyName(DependencyId id, String name) {
        this.ensureDependencyInfoExists(id);
        LazyDependencyInfo info = this.dependencyInfo.get(id);
        info.setName(name);
    }

    public void setDependencyVersion(DependencyId id, String version) {
        this.ensureDependencyInfoExists(id);
        LazyDependencyInfo info = this.dependencyInfo.get(id);
        info.setVersion(version);
    }

    public void setDependencyExternalId(DependencyId id, ExternalId externalId) {
        this.ensureDependencyInfoExists(id);
        LazyDependencyInfo info = this.dependencyInfo.get(id);
        info.setExternalId(externalId);
    }

    public void addParentWithChild(DependencyId parent, DependencyId child) {
        this.ensureDependencyInfoExists(child);
        this.ensureDependencyInfoExists(parent);
        this.dependencyInfo.get(parent).getChildren().add(child);
    }

    public void addParentWithChildren(DependencyId parent, List<DependencyId> children) {
        for (DependencyId child : children) {
            this.addParentWithChild(parent, child);
        }
    }

    public void addParentWithChildren(DependencyId parent, Set<DependencyId> children) {
        for (DependencyId child : children) {
            this.addParentWithChild(parent, child);
        }
    }

    public void addParentWithChildren(DependencyId parent, DependencyId ... children) {
        for (DependencyId child : children) {
            this.addParentWithChild(parent, child);
        }
    }

    public void addChildWithParent(DependencyId child, DependencyId parent) {
        this.addParentWithChild(parent, child);
    }

    public void addChildWithParents(DependencyId child, List<DependencyId> parents) {
        for (DependencyId parent : parents) {
            this.addChildWithParent(child, parent);
        }
    }

    public void addChildWithParents(DependencyId child, Set<DependencyId> parents) {
        for (DependencyId parent : parents) {
            this.addChildWithParent(child, parent);
        }
    }

    public void addChildWithParents(DependencyId child, DependencyId ... parents) {
        for (DependencyId parent : parents) {
            this.addChildWithParent(child, parent);
        }
    }

    public void addChildToRoot(DependencyId child) {
        this.ensureDependencyInfoExists(child);
        this.rootDependencyIds.add(child);
    }

    public void addChildrenToRoot(List<DependencyId> children) {
        for (DependencyId child : children) {
            this.addChildToRoot(child);
        }
    }

    public void addChildrenToRoot(Set<DependencyId> children) {
        for (DependencyId child : children) {
            this.addChildToRoot(child);
        }
    }

    public void addChildrenToRoot(DependencyId ... children) {
        for (DependencyId child : children) {
            this.addChildToRoot(child);
        }
    }

    public static class LazyDependencyInfo {
        private Set<DependencyId> children = new HashSet<DependencyId>();
        private DependencyId aliasId;
        private ExternalId externalId;
        private String name;
        private String version;

        public Set<DependencyId> getChildren() {
            return this.children;
        }

        public void setChildren(Set<DependencyId> children) {
            this.children = children;
        }

        public DependencyId getAliasId() {
            return this.aliasId;
        }

        public void setAliasId(DependencyId aliasId) {
            this.aliasId = aliasId;
        }

        public ExternalId getExternalId() {
            return this.externalId;
        }

        public void setExternalId(ExternalId externalId) {
            this.externalId = externalId;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }
    }
}

