/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.blackduck.codelocation.bdioupload;

import com.synopsys.integration.util.NameVersion;
import java.io.File;
import org.apache.commons.lang3.StringUtils;

public class UploadTarget {
    private final NameVersion projectAndVersion;
    private final String codeLocationName;
    private final File uploadFile;
    private final String mediaType;

    public static UploadTarget createDefault(NameVersion projectAndVersion, String codeLocationName, File uploadFile) {
        return new UploadTarget(projectAndVersion, codeLocationName, uploadFile, "application/ld+json");
    }

    public static UploadTarget createWithMediaType(NameVersion projectAndVersion, String codeLocationName, File uploadFile, String mediaType) {
        return new UploadTarget(projectAndVersion, codeLocationName, uploadFile, mediaType);
    }

    private UploadTarget(NameVersion projectAndVersion, String codeLocationName, File uploadFile, String mediaType) throws IllegalArgumentException {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{projectAndVersion.getName(), projectAndVersion.getVersion()})) {
            throw new IllegalArgumentException("An UploadTarget must have a non-blank project and version.");
        }
        if (StringUtils.isBlank((CharSequence)codeLocationName)) {
            throw new IllegalArgumentException("An UploadTarget must have a non-blank codeLocationName.");
        }
        this.projectAndVersion = projectAndVersion;
        this.codeLocationName = codeLocationName;
        this.uploadFile = uploadFile;
        this.mediaType = mediaType;
    }

    public NameVersion getProjectAndVersion() {
        return this.projectAndVersion;
    }

    public String getCodeLocationName() {
        return this.codeLocationName;
    }

    public File getUploadFile() {
        return this.uploadFile;
    }

    public String getMediaType() {
        return this.mediaType;
    }
}

