/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.plugin.blackduck;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.synopsys.integration.blackduck.api.core.BlackDuckPath;
import com.synopsys.integration.blackduck.api.core.response.BlackDuckPathSingleResponse;
import com.synopsys.integration.blackduck.api.generated.discovery.ApiDiscovery;
import com.synopsys.integration.blackduck.api.generated.response.HealthChecksLivenessView;
import com.synopsys.integration.blackduck.api.generated.view.ProjectVersionView;
import com.synopsys.integration.blackduck.api.generated.view.ProjectView;
import com.synopsys.integration.blackduck.http.BlackDuckRequestFactory;
import com.synopsys.integration.blackduck.service.BlackDuckApiClient;
import com.synopsys.integration.blackduck.service.DataService;
import com.synopsys.integration.exception.IntegrationException;
import com.synopsys.integration.log.IntLogger;
import com.xebialabs.xlrelease.plugin.blackduck.view.ReleaseView;
import com.xebialabs.xlrelease.plugin.blackduck.view.RiskProfileCategoriesView;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BlackDuckCompositeService
extends DataService {
    private static final String HIGH = "HIGH";
    private static final String LOW = "LOW";
    private static final String OK = "OK";
    private static final String CRITICAL = "CRITICAL";
    private static final String MEDIUM = "MEDIUM";
    private static final String VULNERABILITY = "VULNERABILITY";
    private static final String OPERATIONAL = "OPERATIONAL";
    private static final String LICENSE = "LICENSE";
    private static final JsonFactory JSON_FACTORY = new JsonFactory();

    public BlackDuckCompositeService(BlackDuckApiClient blackDuckApiClient, BlackDuckRequestFactory blackDuckRequestFactory, IntLogger logger) {
        super(blackDuckApiClient, blackDuckRequestFactory, logger);
    }

    public List<ReleaseView> getAllReleases(ProjectView projectView) throws IntegrationException, ParseException, IOException {
        ArrayList<ReleaseView> releaseViews = new ArrayList<ReleaseView>();
        List<ProjectVersionView> projectVersionViews = this.blackDuckApiClient.getAllResponses(projectView, ProjectView.VERSIONS_LINK_RESPONSE);
        for (ProjectVersionView v : projectVersionViews) {
            ReleaseView releaseView = new ReleaseView();
            releaseView.createdAt = projectView.getCreatedAt();
            releaseView.id = this.getProjectIdByView(projectView);
            releaseView.version = v.getVersionName();
            releaseView.riskProfile = this.getRiskProfiles(v, projectView);
            releaseView.versionId = this.getProjectVersionIdByView(v);
            releaseViews.add(releaseView);
        }
        return releaseViews;
    }

    public HealthChecksLivenessView getHealthStatus() throws IntegrationException {
        BlackDuckPathSingleResponse<HealthChecksLivenessView> blackDuckPathSingleResponse = new BlackDuckPathSingleResponse<HealthChecksLivenessView>(new BlackDuckPath(ApiDiscovery.HEALTH_CHECKS_LINK.getPath() + "/liveness"), HealthChecksLivenessView.class);
        return this.blackDuckApiClient.getResponse(blackDuckPathSingleResponse);
    }

    public String getProjectIdByView(ProjectView projectView) {
        URL url = projectView.getHref().url();
        return url.getPath().replace(ApiDiscovery.PROJECTS_LINK.toString() + "/", "");
    }

    public String getProjectVersionIdByView(ProjectVersionView projectVersionView) {
        URL url = projectVersionView.getHref().url();
        URL projectUrl = projectVersionView.getFirstLink("project").url();
        return url.getPath().replace(projectUrl.getPath() + "/versions/", "");
    }

    public RiskProfileCategoriesView getRiskProfiles(ProjectVersionView projectVersionView, ProjectView projectView) throws IntegrationException, ParseException, IOException {
        BlackDuckPath blackDuckPath = new BlackDuckPath("api/projects/" + this.getProjectIdByView(projectView) + "/versions/" + this.getProjectVersionIdByView(projectVersionView) + "/risk-profile");
        String response = this.blackDuckApiClient.get(blackDuckPath).getContentString();
        JsonParser jsonParser = JSON_FACTORY.createParser(response);
        HashMap<String, Map<String, Integer>> riskMaps = new HashMap<String, Map<String, Integer>>();
        RiskProfileCategoriesView riskProfileCategoriesView = new RiskProfileCategoriesView();
        while (jsonParser.nextToken() != JsonToken.END_OBJECT) {
            String token = jsonParser.getCurrentName();
            if (token == null || !token.equals("categories")) continue;
            ObjectMapper objectMapper = new ObjectMapper();
            JsonNode categories = objectMapper.readTree((InputStream)new ByteArrayInputStream(response.getBytes(Charset.forName("UTF-8"))));
            JsonNode riskCategories = categories.get("categories");
            riskMaps.put(VULNERABILITY, this.populateRisks(riskCategories.get(VULNERABILITY)));
            riskMaps.put(OPERATIONAL, this.populateRisks(riskCategories.get(OPERATIONAL)));
            riskMaps.put(LICENSE, this.populateRisks(riskCategories.get(LICENSE)));
            String dt = categories.get("bomLastUpdatedAt").textValue();
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
            riskProfileCategoriesView.setBomLastUpdatedAt(format.parse(dt));
            break;
        }
        riskProfileCategoriesView.setCategories(riskMaps);
        return riskProfileCategoriesView;
    }

    private Map<String, Integer> populateRisks(JsonNode node) {
        HashMap<String, Integer> categoryCount = new HashMap<String, Integer>();
        categoryCount.put(CRITICAL, node.get(CRITICAL).intValue());
        categoryCount.put(HIGH, node.get(HIGH).intValue());
        categoryCount.put(MEDIUM, node.get(MEDIUM).intValue());
        categoryCount.put(LOW, node.get(LOW).intValue());
        categoryCount.put(OK, node.get(OK).intValue());
        return categoryCount;
    }
}

