/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.delivery.events.handler;

import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.delivery.events.ItemAvailableEvent;
import com.xebialabs.xlrelease.delivery.events.ItemCompletedEvent;
import com.xebialabs.xlrelease.delivery.events.ItemDescopedEvent;
import com.xebialabs.xlrelease.delivery.events.ItemRemovedEvent;
import com.xebialabs.xlrelease.delivery.events.ItemSkippedEvent;
import com.xebialabs.xlrelease.domain.delivery.Delivery;
import com.xebialabs.xlrelease.domain.delivery.TrackedItemStatus;
import com.xebialabs.xlrelease.domain.delivery.TrackedItemStatusChangeSubscriber;
import com.xebialabs.xlrelease.domain.status.TaskStatus;
import com.xebialabs.xlrelease.events.EventListener;
import com.xebialabs.xlrelease.events.Subscribe;
import com.xebialabs.xlrelease.repository.TaskRepository;
import com.xebialabs.xlrelease.repository.query.TaskBasicData;
import com.xebialabs.xlrelease.user.User;
import java.io.Serializable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Some;
import scala.collection.IterableOnceOps;
import scala.collection.SeqOps;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Component
@EventListener
@ScalaSignature(bytes="\u0006\u0005\u0005]d\u0001\u0002\u0007\u000e\u0001iA\u0001\"\t\u0001\u0003\u0002\u0003\u0006IA\t\u0005\tQ\u0001\u0011\t\u0011)A\u0005S!)q\u0006\u0001C\u0001a!)A\t\u0001C\u0001\u000b\")Q\u000b\u0001C\u0001-\")A\f\u0001C\u0001;\")1\r\u0001C\u0001I\")!\u000e\u0001C\u0001W\")\u0011\u000f\u0001C\u0005e\"I\u0011Q\t\u0001\u0012\u0002\u0013%\u0011q\t\u0005\n\u00037\u0002\u0011\u0013!C\u0005\u0003;\u0012!\u0005\u0016:bG.,G-\u0013;f[N#\u0018\r^;t'V\u00147o\u0019:jE\u0016\u0014\b*\u00198eY\u0016\u0014(B\u0001\b\u0010\u0003\u001dA\u0017M\u001c3mKJT!\u0001E\t\u0002\r\u00154XM\u001c;t\u0015\t\u00112#\u0001\u0005eK2Lg/\u001a:z\u0015\t!R#A\u0005yYJ,G.Z1tK*\u0011acF\u0001\nq\u0016\u0014\u0017.\u00197bENT\u0011\u0001G\u0001\u0004G>l7\u0001A\n\u0003\u0001m\u0001\"\u0001H\u0010\u000e\u0003uQ\u0011AH\u0001\u0006g\u000e\fG.Y\u0005\u0003Au\u0011a!\u00118z%\u00164\u0017a\u0005:fY\u0016\f7/Z!di>\u00148+\u001a:wS\u000e,\u0007CA\u0012'\u001b\u0005!#BA\u0013\u0014\u0003\u0019\t7\r^8sg&\u0011q\u0005\n\u0002\u0014%\u0016dW-Y:f\u0003\u000e$xN]*feZL7-Z\u0001\u000fi\u0006\u001c8NU3q_NLGo\u001c:z!\tQS&D\u0001,\u0015\ta3#\u0001\u0006sKB|7/\u001b;pefL!AL\u0016\u0003\u001dQ\u000b7o\u001b*fa>\u001c\u0018\u000e^8ss\u00061A(\u001b8jiz\"2!M\u001a5!\t\u0011\u0004!D\u0001\u000e\u0011\u0015\t3\u00011\u0001#\u0011\u0015A3\u00011\u0001*Q\t\u0019a\u0007\u0005\u00028\u00056\t\u0001H\u0003\u0002:u\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\u000b\u0005mb\u0014a\u00024bGR|'/\u001f\u0006\u0003{y\nQAY3b]NT!a\u0010!\u0002\u001fM\u0004(/\u001b8hMJ\fW.Z<pe.T\u0011!Q\u0001\u0004_J<\u0017BA\"9\u0005%\tU\u000f^8xSJ,G-A\bp]&#X-\\\"p[BdW\r^3e)\t1\u0015\n\u0005\u0002\u001d\u000f&\u0011\u0001*\b\u0002\u0005+:LG\u000fC\u0003K\t\u0001\u00071*A\u0003fm\u0016tG\u000f\u0005\u0002M\u001b6\tq\"\u0003\u0002O\u001f\t\u0011\u0012\n^3n\u0007>l\u0007\u000f\\3uK\u0012,e/\u001a8uQ\t!\u0001\u000b\u0005\u0002R'6\t!K\u0003\u0002\u0011'%\u0011AK\u0015\u0002\n'V\u00147o\u0019:jE\u0016\fqb\u001c8Ji\u0016l\u0017I^1jY\u0006\u0014G.\u001a\u000b\u0003\r^CQAS\u0003A\u0002a\u0003\"\u0001T-\n\u0005i{!AE%uK6\fe/Y5mC\ndW-\u0012<f]RD#!\u0002)\u0002\u001b=t\u0017\n^3n'.L\u0007\u000f]3e)\t1e\fC\u0003K\r\u0001\u0007q\f\u0005\u0002MA&\u0011\u0011m\u0004\u0002\u0011\u0013R,WnU6jaB,G-\u0012<f]RD#A\u0002)\u0002\u001d=t\u0017\n^3n\t\u0016\u001c8m\u001c9fIR\u0011a)\u001a\u0005\u0006\u0015\u001e\u0001\rA\u001a\t\u0003\u0019\u001eL!\u0001[\b\u0003#%#X-\u001c#fg\u000e|\u0007/\u001a3Fm\u0016tG\u000f\u000b\u0002\b!\u0006iqN\\%uK6\u0014V-\\8wK\u0012$\"A\u00127\t\u000b)C\u0001\u0019A7\u0011\u00051s\u0017BA8\u0010\u0005AIE/Z7SK6|g/\u001a3Fm\u0016tG\u000f\u000b\u0002\t!\u0006Ar-\u001a;BGRLg/Z%uK6\u001cVOY:de&\u0014WM]:\u0015\u0013M\fY!a\u0007\u00020\u0005e\u0002c\u0001;}\u007f:\u0011QO\u001f\b\u0003mfl\u0011a\u001e\u0006\u0003qf\ta\u0001\u0010:p_Rt\u0014\"\u0001\u0010\n\u0005ml\u0012a\u00029bG.\fw-Z\u0005\u0003{z\u00141aU3r\u0015\tYX\u0004\u0005\u0003\u0002\u0002\u0005\u001dQBAA\u0002\u0015\r\t)aK\u0001\u0006cV,'/_\u0005\u0005\u0003\u0013\t\u0019AA\u0007UCN\\')Y:jG\u0012\u000bG/\u0019\u0005\u0007%%\u0001\r!!\u0004\u0011\t\u0005=\u0011qC\u0007\u0003\u0003#Q1AEA\n\u0015\r\t)bE\u0001\u0007I>l\u0017-\u001b8\n\t\u0005e\u0011\u0011\u0003\u0002\t\t\u0016d\u0017N^3ss\"9\u0011QD\u0005A\u0002\u0005}\u0011AB5uK6LE\r\u0005\u0003\u0002\"\u0005%b\u0002BA\u0012\u0003K\u0001\"A^\u000f\n\u0007\u0005\u001dR$\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003W\tiC\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003Oi\u0002\"CA\u0019\u0013A\u0005\t\u0019AA\u001a\u0003\u001d\u0019H/Y4f\u0013\u0012\u0004R\u0001HA\u001b\u0003?I1!a\u000e\u001e\u0005\u0019y\u0005\u000f^5p]\"I\u00111H\u0005\u0011\u0002\u0003\u0007\u0011QH\u0001\u0007gR\fG/^:\u0011\u000bq\t)$a\u0010\u0011\t\u0005=\u0011\u0011I\u0005\u0005\u0003\u0007\n\tBA\tUe\u0006\u001c7.\u001a3Ji\u0016l7\u000b^1ukN\f!eZ3u\u0003\u000e$\u0018N^3Ji\u0016l7+\u001e2tGJL'-\u001a:tI\u0011,g-Y;mi\u0012\u001aTCAA%U\u0011\t\u0019$a\u0013,\u0005\u00055\u0003\u0003BA(\u0003/j!!!\u0015\u000b\t\u0005M\u0013QK\u0001\nk:\u001c\u0007.Z2lK\u0012T!!O\u000f\n\t\u0005e\u0013\u0011\u000b\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AI4fi\u0006\u001bG/\u001b<f\u0013R,WnU;cg\u000e\u0014\u0018NY3sg\u0012\"WMZ1vYR$C'\u0006\u0002\u0002`)\"\u0011QHA&Q\r\u0001\u00111\r\t\u0005\u0003K\nY'\u0004\u0002\u0002h)\u0019\u0011\u0011\u000e \u0002\u0015M$XM]3pif\u0004X-\u0003\u0003\u0002n\u0005\u001d$!C\"p[B|g.\u001a8uQ\r\u0001\u0011\u0011\u000f\t\u0004#\u0006M\u0014bAA;%\niQI^3oi2K7\u000f^3oKJ\u0004")
public class TrackedItemStatusSubscriberHandler {
    private final ReleaseActorService releaseActorService;
    private final TaskRepository taskRepository;

    @Subscribe
    public void onItemCompleted(ItemCompletedEvent event) {
        this.getActiveItemSubscribers(event.delivery(), event.item().getId(), (Option<String>)new Some((Object)event.stage().getId()), (Option<TrackedItemStatus>)new Some((Object)TrackedItemStatus.READY)).foreach((Function1 & Serializable)task -> {
            this.releaseActorService.markTaskAsDone(TaskStatus.COMPLETED, task.taskId(), "All tracked items are completed in stage '" + event.stage().getTitle() + "'", User.SYSTEM);
            return BoxedUnit.UNIT;
        });
    }

    @Subscribe
    public void onItemAvailable(ItemAvailableEvent event) {
        this.getActiveItemSubscribers(event.delivery(), event.item().getId(), (Option<String>)new Some((Object)event.stage().getId()), (Option<TrackedItemStatus>)new Some((Object)TrackedItemStatus.NOT_READY)).foreach((Function1 & Serializable)task -> {
            this.releaseActorService.markTaskAsDone(TaskStatus.COMPLETED, task.taskId(), "All tracked items are available in stage '" + event.stage().getTitle() + "'", User.SYSTEM);
            return BoxedUnit.UNIT;
        });
    }

    @Subscribe
    public void onItemSkipped(ItemSkippedEvent event) {
        this.getActiveItemSubscribers(event.delivery(), event.item().getId(), (Option<String>)new Some((Object)event.stage().getId()), this.getActiveItemSubscribers$default$4()).foreach((Function1 & Serializable)task -> {
            this.releaseActorService.failTask(task.taskId(), "Unable to complete task, tracked item '" + event.item().getTitle() + "' was skipped in stage '" + event.stage().getTitle() + "'", User.SYSTEM, this.releaseActorService.failTask$default$4());
            return BoxedUnit.UNIT;
        });
    }

    @Subscribe
    public void onItemDescoped(ItemDescopedEvent event) {
        this.getActiveItemSubscribers(event.delivery(), event.item().getId(), this.getActiveItemSubscribers$default$3(), this.getActiveItemSubscribers$default$4()).foreach((Function1 & Serializable)task -> {
            this.releaseActorService.failTask(task.taskId(), "Unable to complete task, tracked item '" + event.item().getTitle() + "' was descoped", User.SYSTEM, this.releaseActorService.failTask$default$4());
            return BoxedUnit.UNIT;
        });
    }

    @Subscribe
    public void onItemRemoved(ItemRemovedEvent event) {
        this.getActiveItemSubscribers(event.delivery(), event.item().getId(), this.getActiveItemSubscribers$default$3(), this.getActiveItemSubscribers$default$4()).foreach((Function1 & Serializable)task -> {
            this.releaseActorService.failTask(task.taskId(), "Unable to complete task, tracked item '" + event.item().getTitle() + "' was removed", User.SYSTEM, this.releaseActorService.failTask$default$4());
            return BoxedUnit.UNIT;
        });
    }

    private Seq<TaskBasicData> getActiveItemSubscribers(Delivery delivery, String itemId, Option<String> stageId, Option<TrackedItemStatus> status) {
        Buffer taskIds = (Buffer)((SeqOps)CollectionConverters$.MODULE$.ListHasAsScala(delivery.getSubscribersOfType(TrackedItemStatusChangeSubscriber.class)).asScala().collect((PartialFunction)new Serializable(null, delivery, itemId, stageId, status){
            private static final long serialVersionUID = 0L;
            private final Delivery delivery$1;
            private final String itemId$1;
            private final Option stageId$1;
            private final Option status$1;

            public final <A1 extends TrackedItemStatusChangeSubscriber, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1.matches(this.delivery$1, this.itemId$1, this.stageId$1, this.status$1)) {
                    return (B1)A1.sourceId();
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(TrackedItemStatusChangeSubscriber x1) {
                TrackedItemStatusChangeSubscriber trackedItemStatusChangeSubscriber = x1;
                return trackedItemStatusChangeSubscriber.matches(this.delivery$1, this.itemId$1, this.stageId$1, this.status$1);
            }
            {
                this.delivery$1 = delivery$1;
                this.itemId$1 = itemId$1;
                this.stageId$1 = stageId$1;
                this.status$1 = status$1;
            }
        })).distinct();
        return ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(this.taskRepository.findTasksBasicData(CollectionConverters$.MODULE$.BufferHasAsJava(taskIds).asJava())).asScala().filter((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)TrackedItemStatusSubscriberHandler.$anonfun$getActiveItemSubscribers$1(x$2)))).toSeq();
    }

    private Option<String> getActiveItemSubscribers$default$3() {
        return None$.MODULE$;
    }

    private Option<TrackedItemStatus> getActiveItemSubscribers$default$4() {
        return None$.MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$getActiveItemSubscribers$1(TaskBasicData x$2) {
        TaskStatus taskStatus = x$2.status();
        TaskStatus taskStatus2 = TaskStatus.IN_PROGRESS;
        return !(taskStatus != null ? !taskStatus.equals(taskStatus2) : taskStatus2 != null);
    }

    @Autowired
    public TrackedItemStatusSubscriberHandler(ReleaseActorService releaseActorService, TaskRepository taskRepository) {
        this.releaseActorService = releaseActorService;
        this.taskRepository = taskRepository;
    }
}

