/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.delivery.repository.sql;

import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional;
import com.xebialabs.xlrelease.delivery.repository.DeliveryRepository;
import com.xebialabs.xlrelease.domain.delivery.Delivery;
import com.xebialabs.xlrelease.domain.delivery.DeliveryStatus;
import com.xebialabs.xlrelease.limits.LimitEnforcer;
import com.xebialabs.xlrelease.repository.PersistenceInterceptor;
import org.springframework.stereotype.Repository;
import scala.Predef$;
import scala.reflect.ScalaSignature;

@IsTransactional
@Repository
@ScalaSignature(bytes="\u0006\u0005e3A!\u0002\u0004\u0001'!A\u0001\u0006\u0001B\u0001B\u0003%\u0011\u0006\u0003\u0005.\u0001\t\u0005\t\u0015!\u0003/\u0011\u0015!\u0004\u0001\"\u00016\u0011\u0015Q\u0004\u0001\"\u0011<\u0005\r\"U\r\\5wKJLH*[7jiB+'o]5ti\u0016t7-Z%oi\u0016\u00148-\u001a9u_JT!a\u0002\u0005\u0002\u0007M\fHN\u0003\u0002\n\u0015\u0005Q!/\u001a9pg&$xN]=\u000b\u0005-a\u0011\u0001\u00033fY&4XM]=\u000b\u00055q\u0011!\u0003=me\u0016dW-Y:f\u0015\ty\u0001#A\u0005yK\nL\u0017\r\\1cg*\t\u0011#A\u0002d_6\u001c\u0001aE\u0002\u0001)q\u0001\"!\u0006\u000e\u000e\u0003YQ!a\u0006\r\u0002\t1\fgn\u001a\u0006\u00023\u0005!!.\u0019<b\u0013\tYbC\u0001\u0004PE*,7\r\u001e\t\u0004;}\tS\"\u0001\u0010\u000b\u0005%a\u0011B\u0001\u0011\u001f\u0005Y\u0001VM]:jgR,gnY3J]R,'oY3qi>\u0014\bC\u0001\u0012'\u001b\u0005\u0019#BA\u0006%\u0015\t)C\"\u0001\u0004e_6\f\u0017N\\\u0005\u0003O\r\u0012\u0001\u0002R3mSZ,'/_\u0001\u0013I\u0016d\u0017N^3ssJ+\u0007o\\:ji>\u0014\u0018\u0010\u0005\u0002+W5\t\u0001\"\u0003\u0002-\u0011\t\u0011B)\u001a7jm\u0016\u0014\u0018PU3q_NLGo\u001c:z\u00035a\u0017.\\5u\u000b:4wN]2feB\u0011qFM\u0007\u0002a)\u0011\u0011\u0007D\u0001\u0007Y&l\u0017\u000e^:\n\u0005M\u0002$!\u0004'j[&$XI\u001c4pe\u000e,'/\u0001\u0004=S:LGO\u0010\u000b\u0004maJ\u0004CA\u001c\u0001\u001b\u00051\u0001\"\u0002\u0015\u0004\u0001\u0004I\u0003\"B\u0017\u0004\u0001\u0004q\u0013\u0001C8o\u0007J,\u0017\r^3\u0015\u0005q\u0012\u0005CA\u001fA\u001b\u0005q$\"A \u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0005s$\u0001B+oSRDQa\u0011\u0003A\u0002\u0005\n!aY5)\u0005\u0001)\u0005C\u0001$M\u001b\u00059%B\u0001%J\u0003-!(/\u00198tC\u000e$\u0018n\u001c8\u000b\u0005\u001dQ%BA&\r\u0003\t!'-\u0003\u0002N\u000f\ny\u0011j\u001d+sC:\u001c\u0018m\u0019;j_:\fG\u000e\u000b\u0002\u0001\u001fB\u0011\u0001kV\u0007\u0002#*\u0011!kU\u0001\u000bgR,'/Z8usB,'B\u0001+V\u0003=\u0019\bO]5oO\u001a\u0014\u0018-\\3x_J\\'\"\u0001,\u0002\u0007=\u0014x-\u0003\u0002Y#\nQ!+\u001a9pg&$xN]=")
public class DeliveryLimitPersistenceInterceptor
implements PersistenceInterceptor<Delivery> {
    private final DeliveryRepository deliveryRepository;
    private final LimitEnforcer limitEnforcer;

    public void onDelete(String ciId) {
        super.onDelete(ciId);
    }

    public void onUpdate(ConfigurationItem ci) {
        super.onUpdate(ci);
    }

    public void afterCreate(ConfigurationItem ci) {
        super.afterCreate(ci);
    }

    public void afterUpdate(ConfigurationItem ci) {
        super.afterUpdate(ci);
    }

    public void afterDelete(String ciId) {
        super.afterDelete(ciId);
    }

    public void onCreate(Delivery ci) {
        String tenantId = ci.getTenantId();
        DeliveryStatus deliveryStatus = ci.getStatus();
        if (DeliveryStatus.TEMPLATE.equals(deliveryStatus)) {
            this.limitEnforcer.enforceLimit(tenantId, LimitEnforcer.LimitType.PATTERNS, 1, () -> Predef$.MODULE$.Integer2int($this.deliveryRepository.tenantPatternCount(tenantId)));
            return;
        }
        this.limitEnforcer.enforceLimit(tenantId, LimitEnforcer.LimitType.DELIVERIES, 1, () -> Predef$.MODULE$.Integer2int($this.deliveryRepository.tenantDeliveryCount(tenantId)));
    }

    public DeliveryLimitPersistenceInterceptor(DeliveryRepository deliveryRepository, LimitEnforcer limitEnforcer) {
        this.deliveryRepository = deliveryRepository;
        this.limitEnforcer = limitEnforcer;
        deliveryRepository.registerPersistenceInterceptor(this);
    }
}

