/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.asyncutil.locks;

import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import sun.misc.Unsafe;

final class PlatformDependent {
    private PlatformDependent() {
    }

    public static boolean loadFence() {
        return AlternativeHolder.UNSAFE_PROVIDER.loadFence();
    }

    public static boolean storeFence() {
        return AlternativeHolder.UNSAFE_PROVIDER.storeFence();
    }

    public static boolean fullFence() {
        return AlternativeHolder.UNSAFE_PROVIDER.fullFence();
    }

    private static UnsafeProvider safeJavaImpl() {
        return AlternativeHolder.PureJavaAlternative.INSTANCE;
    }

    private static class AlternativeHolder {
        static final String UNSAFE_ALTERNATIVE_NAME = AlternativeHolder.class.getName() + "$UnsafeAlternative";
        static final UnsafeProvider UNSAFE_PROVIDER = AlternativeHolder.getUnsafeProvider();

        private AlternativeHolder() {
        }

        static UnsafeProvider getUnsafeProvider() {
            try {
                Class<?> theClass = Class.forName(UNSAFE_ALTERNATIVE_NAME);
                UnsafeProvider comparer = (UnsafeProvider)theClass.getEnumConstants()[0];
                return comparer;
            }
            catch (Throwable t) {
                return PlatformDependent.safeJavaImpl();
            }
        }

        private static enum UnsafeAlternative implements UnsafeProvider
        {
            INSTANCE;

            private static final Unsafe unsafe;

            @Override
            public boolean loadFence() {
                unsafe.loadFence();
                return true;
            }

            @Override
            public boolean storeFence() {
                unsafe.storeFence();
                return true;
            }

            @Override
            public boolean fullFence() {
                unsafe.fullFence();
                return true;
            }

            static {
                unsafe = (Unsafe)AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        try {
                            Field f = Unsafe.class.getDeclaredField("theUnsafe");
                            f.setAccessible(true);
                            return f.get(null);
                        }
                        catch (NoSuchFieldException e) {
                            throw new Error(e);
                        }
                        catch (IllegalAccessException e) {
                            throw new Error(e);
                        }
                    }
                });
                if (unsafe.arrayIndexScale(byte[].class) != 1) {
                    throw new AssertionError();
                }
            }
        }

        private static enum PureJavaAlternative implements UnsafeProvider
        {
            INSTANCE;


            @Override
            public boolean loadFence() {
                return false;
            }

            @Override
            public boolean storeFence() {
                return false;
            }

            @Override
            public boolean fullFence() {
                return false;
            }
        }
    }

    private static interface UnsafeProvider {
        public boolean loadFence();

        public boolean storeFence();

        public boolean fullFence();
    }
}

