/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.persistence.jdbc.config;

import com.typesafe.config.Config;
import org.apache.pekko.persistence.jdbc.config.EventJournalTableConfiguration;
import org.apache.pekko.persistence.jdbc.config.EventTagTableConfiguration;
import org.apache.pekko.persistence.jdbc.config.JournalSequenceRetrievalConfig;
import org.apache.pekko.persistence.jdbc.config.JournalSequenceRetrievalConfig$;
import org.apache.pekko.persistence.jdbc.config.LegacyJournalTableConfiguration;
import org.apache.pekko.persistence.jdbc.config.ReadJournalPluginConfig;
import org.apache.pekko.persistence.jdbc.util.ConfigOps$ConfigOperations$;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005e4A\u0001F\u000b\u0001E!Aa\u0003\u0001B\u0001B\u0003%\u0011\u0006C\u00033\u0001\u0011\u00051\u0007C\u00048\u0001\t\u0007I\u0011\u0001\u001d\t\rq\u0002\u0001\u0015!\u0003:\u0011\u001di\u0004A1A\u0005\u0002yBaA\u0011\u0001!\u0002\u0013y\u0004bB\"\u0001\u0005\u0004%\t\u0001\u0012\u0005\u0007\u0011\u0002\u0001\u000b\u0011B#\t\u000f%\u0003!\u0019!C\u0001\u0015\"1a\n\u0001Q\u0001\n-Cqa\u0014\u0001C\u0002\u0013\u0005\u0001\u000b\u0003\u0004U\u0001\u0001\u0006I!\u0015\u0005\b+\u0002\u0011\r\u0011\"\u0001W\u0011\u0019y\u0006\u0001)A\u0005/\"9\u0001\r\u0001b\u0001\n\u0003\t\u0007BB3\u0001A\u0003%!\rC\u0004g\u0001\t\u0007I\u0011A4\t\r-\u0004\u0001\u0015!\u0003i\u0011\u0015a\u0007\u0001\"\u0011n\u0005E\u0011V-\u00193K_V\u0014h.\u00197D_:4\u0017n\u001a\u0006\u0003-]\taaY8oM&<'B\u0001\r\u001a\u0003\u0011QGMY2\u000b\u0005iY\u0012a\u00039feNL7\u000f^3oG\u0016T!\u0001H\u000f\u0002\u000bA,7n[8\u000b\u0005yy\u0012AB1qC\u000eDWMC\u0001!\u0003\ry'oZ\u0002\u0001'\t\u00011\u0005\u0005\u0002%O5\tQEC\u0001'\u0003\u0015\u00198-\u00197b\u0013\tASE\u0001\u0004B]f\u0014VM\u001a\t\u0003UAj\u0011a\u000b\u0006\u0003-1R!!\f\u0018\u0002\u0011QL\b/Z:bM\u0016T\u0011aL\u0001\u0004G>l\u0017BA\u0019,\u0005\u0019\u0019uN\u001c4jO\u00061A(\u001b8jiz\"\"\u0001\u000e\u001c\u0011\u0005U\u0002Q\"A\u000b\t\u000bY\u0011\u0001\u0019A\u0015\u00023)|WO\u001d8bYR\u000b'\r\\3D_:4\u0017nZ;sCRLwN\\\u000b\u0002sA\u0011QGO\u0005\u0003wU\u0011q\u0004T3hC\u000eL(j\\;s]\u0006dG+\u00192mK\u000e{gNZ5hkJ\fG/[8o\u0003iQw.\u001e:oC2$\u0016M\u00197f\u0007>tg-[4ve\u0006$\u0018n\u001c8!\u0003y)g/\u001a8u\u0015>,(O\\1m)\u0006\u0014G.Z\"p]\u001aLw-\u001e:bi&|g.F\u0001@!\t)\u0004)\u0003\u0002B+\tqRI^3oi*{WO\u001d8bYR\u000b'\r\\3D_:4\u0017nZ;sCRLwN\\\u0001 KZ,g\u000e\u001e&pkJt\u0017\r\u001c+bE2,7i\u001c8gS\u001e,(/\u0019;j_:\u0004\u0013AG3wK:$H+Y4UC\ndWmQ8oM&<WO]1uS>tW#A#\u0011\u0005U2\u0015BA$\u0016\u0005i)e/\u001a8u)\u0006<G+\u00192mK\u000e{gNZ5hkJ\fG/[8o\u0003m)g/\u001a8u)\u0006<G+\u00192mK\u000e{gNZ5hkJ\fG/[8oA\u0005)#n\\;s]\u0006d7+Z9vK:\u001cWMU3ue&,g/\u00197D_:4\u0017nZ;sCRLwN\\\u000b\u0002\u0017B\u0011Q\u0007T\u0005\u0003\u001bV\u0011aDS8ve:\fGnU3rk\u0016t7-\u001a*fiJLWM^1m\u0007>tg-[4\u0002M)|WO\u001d8bYN+\u0017/^3oG\u0016\u0014V\r\u001e:jKZ\fGnQ8oM&<WO]1uS>t\u0007%\u0001\u0007qYV<\u0017N\\\"p]\u001aLw-F\u0001R!\t)$+\u0003\u0002T+\t9\"+Z1e\u0015>,(O\\1m!2,x-\u001b8D_:4\u0017nZ\u0001\u000ea2,x-\u001b8D_:4\u0017n\u001a\u0011\u0002\u001fI,gM]3tQ&sG/\u001a:wC2,\u0012a\u0016\t\u00031vk\u0011!\u0017\u0006\u00035n\u000b\u0001\u0002Z;sCRLwN\u001c\u0006\u00039\u0016\n!bY8oGV\u0014(/\u001a8u\u0013\tq\u0016L\u0001\bGS:LG/\u001a#ve\u0006$\u0018n\u001c8\u0002!I,gM]3tQ&sG/\u001a:wC2\u0004\u0013!D7bq\n+hMZ3s'&TX-F\u0001c!\t!3-\u0003\u0002eK\t\u0019\u0011J\u001c;\u0002\u001d5\f\u0007PQ;gM\u0016\u00148+\u001b>fA\u0005y\u0011\r\u001a3TQV$Hm\\<o\u0011>|7.F\u0001i!\t!\u0013.\u0003\u0002kK\t9!i\\8mK\u0006t\u0017\u0001E1eINCW\u000f\u001e3po:Dun\\6!\u0003!!xn\u0015;sS:<G#\u00018\u0011\u0005=4hB\u00019u!\t\tX%D\u0001s\u0015\t\u0019\u0018%\u0001\u0004=e>|GOP\u0005\u0003k\u0016\na\u0001\u0015:fI\u00164\u0017BA<y\u0005\u0019\u0019FO]5oO*\u0011Q/\n")
public class ReadJournalConfig {
    private final LegacyJournalTableConfiguration journalTableConfiguration;
    private final EventJournalTableConfiguration eventJournalTableConfiguration;
    private final EventTagTableConfiguration eventTagTableConfiguration;
    private final JournalSequenceRetrievalConfig journalSequenceRetrievalConfiguration;
    private final ReadJournalPluginConfig pluginConfig;
    private final FiniteDuration refreshInterval;
    private final int maxBufferSize;
    private final boolean addShutdownHook;

    public LegacyJournalTableConfiguration journalTableConfiguration() {
        return this.journalTableConfiguration;
    }

    public EventJournalTableConfiguration eventJournalTableConfiguration() {
        return this.eventJournalTableConfiguration;
    }

    public EventTagTableConfiguration eventTagTableConfiguration() {
        return this.eventTagTableConfiguration;
    }

    public JournalSequenceRetrievalConfig journalSequenceRetrievalConfiguration() {
        return this.journalSequenceRetrievalConfiguration;
    }

    public ReadJournalPluginConfig pluginConfig() {
        return this.pluginConfig;
    }

    public FiniteDuration refreshInterval() {
        return this.refreshInterval;
    }

    public int maxBufferSize() {
        return this.maxBufferSize;
    }

    public boolean addShutdownHook() {
        return this.addShutdownHook;
    }

    public String toString() {
        return new StringBuilder(23).append("ReadJournalConfig(").append(this.journalTableConfiguration()).append(",").append(this.pluginConfig()).append(",").append(this.refreshInterval()).append(",").append(this.maxBufferSize()).append(",").append(this.addShutdownHook()).append(")").toString();
    }

    public ReadJournalConfig(Config config) {
        this.journalTableConfiguration = new LegacyJournalTableConfiguration(config);
        this.eventJournalTableConfiguration = new EventJournalTableConfiguration(config);
        this.eventTagTableConfiguration = new EventTagTableConfiguration(config);
        this.journalSequenceRetrievalConfiguration = JournalSequenceRetrievalConfig$.MODULE$.apply(config);
        this.pluginConfig = new ReadJournalPluginConfig(config);
        this.refreshInterval = ConfigOps$ConfigOperations$.MODULE$.asFiniteDuration$extension(config, "refresh-interval");
        this.maxBufferSize = config.getInt("max-buffer-size");
        this.addShutdownHook = config.getBoolean("add-shutdown-hook");
    }
}

