/*
 * Decompiled with CFR 0.152.
 */
package com.samskivert.mustache;

import com.samskivert.mustache.Mustache;
import com.samskivert.mustache.MustacheException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.Map;

public class Template {
    public static final Object NO_FETCHER_FOUND = new String("<no fetcher found>");
    protected final Segment[] _segs;
    protected final Mustache.Compiler _compiler;
    protected final Map<Key, Mustache.VariableFetcher> _fcache;
    protected static final String DOT_NAME = ".";
    protected static final String THIS_NAME = "this";
    protected static final String FIRST_NAME = "-first";
    protected static final String LAST_NAME = "-last";
    protected static final String INDEX_NAME = "-index";
    protected static Mustache.VariableFetcher NOT_FOUND_FETCHER = new Mustache.VariableFetcher(){

        @Override
        public Object get(Object ctx, String name) throws Exception {
            return NO_FETCHER_FOUND;
        }
    };

    public String execute(Object context) throws MustacheException {
        StringWriter out = new StringWriter();
        this.execute(context, out);
        return out.toString();
    }

    public void execute(Object context, Writer out) throws MustacheException {
        this.executeSegs(new Context(context, null, 0, false, false), out);
    }

    public void execute(Object context, Object parentContext, Writer out) throws MustacheException {
        Context pctx = new Context(parentContext, null, 0, false, false);
        this.executeSegs(new Context(context, pctx, 0, false, false), out);
    }

    public void visit(Mustache.Visitor visitor) {
        for (Segment seg : this._segs) {
            seg.visit(visitor);
        }
    }

    protected Template(Segment[] segs, Mustache.Compiler compiler) {
        this._segs = segs;
        this._compiler = compiler;
        this._fcache = compiler.collector.createFetcherCache();
    }

    protected Template indent(String indent) {
        if (indent.equals("")) {
            return this;
        }
        Segment[] copySegs = Mustache.indentSegs(this._segs, indent, false, false);
        if (copySegs == this._segs) {
            return this;
        }
        return new Template(copySegs, this._compiler);
    }

    protected Template replaceBlocks(Map<String, Mustache.BlockSegment> blocks) {
        if (blocks.isEmpty()) {
            return this;
        }
        Segment[] copySegs = Mustache.replaceBlockSegs(this._segs, blocks);
        if (copySegs == this._segs) {
            return this;
        }
        return new Template(copySegs, this._compiler);
    }

    protected void executeSegs(Context ctx, Writer out) throws MustacheException {
        for (Segment seg : this._segs) {
            seg.execute(this, ctx, out);
        }
    }

    protected Fragment createFragment(final Segment[] segs, final Context currentCtx) {
        return new Fragment(){

            @Override
            public void execute(Writer out) {
                this.execute(currentCtx, out);
            }

            @Override
            public void execute(Object context, Writer out) {
                this.execute(currentCtx.nest(context), out);
            }

            @Override
            public void executeTemplate(Template tmpl, Writer out) {
                tmpl.executeSegs(currentCtx, out);
            }

            @Override
            public Object context() {
                return currentCtx.data;
            }

            @Override
            public Object context(int n) {
                return this.context(currentCtx, n);
            }

            @Override
            public StringBuilder decompile(StringBuilder into) {
                for (Segment seg : segs) {
                    seg.decompile(Template.this._compiler.delims, into);
                }
                return into;
            }

            private Object context(Context ctx, int n) {
                return n == 0 ? ctx.data : this.context(ctx.parent, n - 1);
            }

            private void execute(Context ctx, Writer out) {
                for (Segment seg : segs) {
                    seg.execute(Template.this, ctx, out);
                }
            }
        };
    }

    protected Object getValue(Context ctx, String name, int line, boolean missingIsNull) {
        if (name.equals(FIRST_NAME)) {
            return ctx.onFirst;
        }
        if (name.equals(LAST_NAME)) {
            return ctx.onLast;
        }
        if (name.equals(INDEX_NAME)) {
            return ctx.index;
        }
        if (this._compiler.standardsMode) {
            Object value = this.getValueIn(ctx.data, name, line);
            return this.checkForMissing(name, line, missingIsNull, value);
        }
        Context pctx = ctx;
        while (pctx != null) {
            Object value = this.getValueIn(pctx.data, name, line);
            if (value != NO_FETCHER_FOUND) {
                return value;
            }
            pctx = pctx.parent;
        }
        if (!name.equals(DOT_NAME) && name.indexOf(DOT_NAME) != -1) {
            return this.getCompoundValue(ctx, name, line, missingIsNull);
        }
        return this.checkForMissing(name, line, missingIsNull, NO_FETCHER_FOUND);
    }

    protected Object getCompoundValue(Context ctx, String name, int line, boolean missingIsNull) {
        String[] comps = name.split("\\.");
        Object data = this.getValue(ctx, comps[0], line, missingIsNull);
        for (int ii = 1; ii < comps.length; ++ii) {
            if (data == NO_FETCHER_FOUND) {
                if (!missingIsNull) {
                    throw new MustacheException.Context("Missing context for compound variable '" + name + "' on line " + line + ". '" + comps[ii - 1] + "' was not found.", name, line);
                }
                return null;
            }
            if (data == null) {
                return null;
            }
            data = this.getValueIn(data, comps[ii], line);
        }
        return this.checkForMissing(name, line, missingIsNull, data);
    }

    protected Object getSectionValue(Context ctx, String name, int line) {
        Object value = this.getValue(ctx, name, line, !this._compiler.strictSections);
        return value == null ? Collections.emptyList() : value;
    }

    protected Object getValueOrDefault(Context ctx, String name, int line) {
        Object value = this.getValue(ctx, name, line, this._compiler.missingIsNull);
        return value == null ? this._compiler.computeNullValue(name) : value;
    }

    protected Object getValueIn(Object data, String name, int line) {
        if (Template.isThisName(name)) {
            return data;
        }
        if (data == null) {
            throw new NullPointerException("Null context for variable '" + name + "' on line " + line);
        }
        Key key = new Key(data.getClass(), name);
        Mustache.VariableFetcher fetcher = this._fcache.get(key);
        if (fetcher != null) {
            try {
                return fetcher.get(data, name);
            }
            catch (Exception e) {
                fetcher = this._compiler.collector.createFetcher(data, key.name);
            }
        } else {
            fetcher = this._compiler.collector.createFetcher(data, key.name);
        }
        if (fetcher == null) {
            fetcher = NOT_FOUND_FETCHER;
        }
        try {
            Object value = fetcher.get(data, name);
            this._fcache.put(key, fetcher);
            return value;
        }
        catch (Exception e) {
            throw new MustacheException.Context("Failure fetching variable '" + name + "' on line " + line, name, line, e);
        }
    }

    protected Object checkForMissing(String name, int line, boolean missingIsNull, Object value) {
        if (value == NO_FETCHER_FOUND) {
            if (missingIsNull) {
                return null;
            }
            throw new MustacheException.Context("No method or field with name '" + name + "' on line " + line, name, line);
        }
        return value;
    }

    protected static boolean isThisName(String name) {
        return DOT_NAME.equals(name) || THIS_NAME.equals(name);
    }

    protected static class Context {
        public final Object data;
        public final Context parent;
        public final int index;
        public final boolean onFirst;
        public final boolean onLast;

        public Context(Object data, Context parent, int index, boolean onFirst, boolean onLast) {
            this.data = data;
            this.parent = parent;
            this.index = index;
            this.onFirst = onFirst;
            this.onLast = onLast;
        }

        public Context nest(Object data) {
            return new Context(data, this, this.index, this.onFirst, this.onLast);
        }

        public Context nest(Object data, int index, boolean onFirst, boolean onLast) {
            return new Context(data, this, index, onFirst, onLast);
        }
    }

    protected static abstract class Segment {
        protected Segment() {
        }

        abstract void execute(Template var1, Context var2, Writer var3);

        abstract void decompile(Mustache.Delims var1, StringBuilder var2);

        abstract void visit(Mustache.Visitor var1);

        abstract Segment indent(String var1, boolean var2, boolean var3);

        abstract boolean isStandalone();

        protected static void write(Writer out, CharSequence data) {
            try {
                out.append(data);
            }
            catch (IOException ioe) {
                throw new MustacheException(ioe);
            }
        }
    }

    protected static class Key {
        public final Class<?> cclass;
        public final String name;

        public Key(Class<?> cclass, String name) {
            this.cclass = cclass;
            this.name = name;
        }

        public int hashCode() {
            return this.cclass.hashCode() * 31 + this.name.hashCode();
        }

        public boolean equals(Object other) {
            Key okey = (Key)other;
            return okey.cclass == this.cclass && okey.name.equals(this.name);
        }

        public String toString() {
            return this.cclass.getName() + ":" + this.name;
        }
    }

    public abstract class Fragment {
        public abstract void execute(Writer var1);

        public abstract void execute(Object var1, Writer var2);

        public abstract void executeTemplate(Template var1, Writer var2);

        public String execute() {
            StringWriter out = new StringWriter();
            this.execute(out);
            return out.toString();
        }

        public String execute(Object context) {
            StringWriter out = new StringWriter();
            this.execute(context, out);
            return out.toString();
        }

        public abstract Object context();

        public abstract Object context(int var1);

        public String decompile() {
            return this.decompile(new StringBuilder()).toString();
        }

        public abstract StringBuilder decompile(StringBuilder var1);
    }
}

