/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.internal;

import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import com.xebialabs.xlrelease.domain.BaseConfiguration;
import com.xebialabs.xlrelease.domain.Configuration;
import com.xebialabs.xlrelease.domain.runner.RemoteJobRunner;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.runner.domain.RunnerToken;
import com.xebialabs.xlrelease.runner.service.RunnerTokenService;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.service.CiIdService;
import com.xebialabs.xlrelease.service.ConfigurationService;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.springframework.stereotype.Controller;

@Path(value="/fixtures/runners")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Controller
@NoCache
public class FixturesRunnerResource {
    private PermissionChecker permissions;
    private CiIdService ciIdService;
    private ConfigurationService configurationService;
    private RunnerTokenService runnerTokenService;

    public FixturesRunnerResource(PermissionChecker permissions, CiIdService ciIdService, ConfigurationService configurationService, RunnerTokenService runnerTokenService) {
        this.permissions = permissions;
        this.ciIdService = ciIdService;
        this.configurationService = configurationService;
        this.runnerTokenService = runnerTokenService;
    }

    @POST
    @Path(value="register")
    public RunnerToken registerRunner() {
        this.permissions.check(PlatformPermissions.ADMIN);
        String id = this.ciIdService.getUniqueId(Type.valueOf(Configuration.class), Ids.CUSTOM_CONFIGURATION_ROOT);
        Date expiryDate = Date.from(Instant.now().plus(7L, ChronoUnit.DAYS));
        RemoteJobRunner newRunner = (RemoteJobRunner)Type.valueOf(RemoteJobRunner.class).getDescriptor().newInstance(id);
        newRunner.setTitle("Runner - xyz");
        newRunner.setCapabilities(new HashSet<String>(Arrays.asList("remote", "container")));
        newRunner.setPublicKey("Dummy public key");
        newRunner.setVersion("development");
        newRunner.setRunnerName("dev-remote-runner");
        this.configurationService.createOrUpdate((BaseConfiguration)newRunner);
        return this.runnerTokenService.createOrUpdateRunnerToken(id, expiryDate);
    }

    @DELETE
    @Path(value="{id:Configuration.*}")
    public void deleteRunner(@PathParam(value="id") String id) {
        this.permissions.check(PlatformPermissions.ADMIN);
        this.configurationService.delete(id);
        this.runnerTokenService.deleteRunnerToken(id);
    }
}

