/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.udm.reporting;

import com.xebialabs.xlrelease.domain.udm.reporting.DeploymentStatus;

public enum DeploymentAction {
    NO_ACTION("no_action"),
    STARTED("started", DeploymentStatus.IN_PROGRESS),
    FAILED("failed", DeploymentStatus.FAILED),
    RETRIED("retried", DeploymentStatus.IN_PROGRESS, DeploymentStatus.FAILED),
    SKIPPED("skipped", DeploymentStatus.SKIPPED),
    ABORTED("aborted", DeploymentStatus.ABORTED),
    COMPLETED("completed", DeploymentStatus.COMPLETED);

    private final String value;
    private DeploymentStatus newStatus;
    private DeploymentStatus oldStatus;

    private DeploymentAction(String v) {
        this(v, null);
    }

    private DeploymentAction(String v, DeploymentStatus newStatus) {
        this(v, newStatus, null);
    }

    private DeploymentAction(String v, DeploymentStatus newStatus, DeploymentStatus oldStatus) {
        this.value = v;
        this.newStatus = newStatus;
        this.oldStatus = oldStatus;
    }

    public String value() {
        return this.value;
    }

    public static DeploymentAction fromStatus(DeploymentStatus oldStatus, DeploymentStatus newStatus) {
        for (DeploymentAction action : DeploymentAction.values()) {
            if (action.oldStatus != oldStatus || action.newStatus != newStatus) continue;
            return action;
        }
        for (DeploymentAction action : DeploymentAction.values()) {
            if (action.newStatus != newStatus) continue;
            return action;
        }
        return NO_ACTION;
    }

    public static DeploymentAction find(String value) {
        for (DeploymentAction action : DeploymentAction.values()) {
            if (!action.value().equals(value)) continue;
            return action;
        }
        throw new IllegalStateException(String.format("Unknown deployment action [%s].", value));
    }
}

