/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.domain;

import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.xlplatform.documentation.PublicApiMember;
import com.xebialabs.xlplatform.documentation.PublicApiRef;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;
import com.xebialabs.xlrelease.domain.Changes;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.status.TaskStatus;
import com.xebialabs.xlrelease.domain.variables.Variable;
import com.xebialabs.xlrelease.domain.variables.reference.PropertyUsagePoint;
import com.xebialabs.xlrelease.domain.variables.reference.UsagePoint;
import com.xebialabs.xlrelease.events.TaskStartOrRetryOperation;
import com.xebialabs.xlrelease.repository.CiProperty;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.risk.domain.RiskProfile;
import com.xebialabs.xlrelease.service.ExecuteTaskAction;
import com.xebialabs.xlrelease.variable.ValueWithInterpolation;
import com.xebialabs.xlrelease.variable.VariableHelper;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

@PublicApiRef
@ShowOnlyPublicApiMembers
@Metadata(label="Create Release", versioned=false, description="Automates the creation of a new release")
public class CreateReleaseTask
extends Task {
    public static final String CREATED_RELEASE_ID = "createdReleaseId";
    public static final String TEMPLATE_ID = "templateId";
    public static final String FOLDER_ID = "folderId";
    @Property(label="Release title", description="Title of the release to create.")
    private String newReleaseTitle;
    @Property(label="Template", description="Template that will be used to create a release.")
    private String templateId;
    @Property(required=false, category="internal")
    private String templateIdVariable;
    @Property(label="Folder", description="Folder in which to create a release.")
    private String folderId;
    @Property(label="Start release", required=false, defaultValue="true", description="Immediately start the release after it is created.")
    private boolean startRelease = true;
    @Property(asContainment=true, required=false, label="Variables", description="Variable values to pass to the created release.")
    protected List<Variable> templateVariables = new ArrayList<Variable>();
    @Property(required=false, category="output", label="Created release ID", description="ID of the release created from this task.")
    private String createdReleaseId;
    @Property(required=false, label="Release tags", description="Tags that will be propagated to the created release along with Template tags.")
    private Set<String> releaseTags = new HashSet<String>();
    @Property(required=false, description="Risk profile that will be used by the created release.")
    private RiskProfile riskProfile;
    @Property(required=false, defaultValue="false", label="Wait for release to finish", description="This task will stay in progress until the created release is completed or aborted.")
    private boolean waitForRelease = false;

    @Override
    protected Changes execute(String targetId, TaskStartOrRetryOperation operation) {
        Changes changes = super.execute(targetId, operation);
        if (this.getStatus() != TaskStatus.IN_PROGRESS) {
            return changes;
        }
        this.generateExecutionId();
        changes.update((ConfigurationItem)this);
        changes.addPostAction(new ExecuteTaskAction(this));
        return changes;
    }

    @Override
    public Set<String> freezeVariablesInCustomFields(Map<String, ValueWithInterpolation> variables, Map<String, String> passwordVariables, Changes changes, boolean freezeEvenIfUnresolved) {
        HashSet<String> unresolvedVariables = new HashSet<String>();
        this.setNewReleaseTitle(VariableHelper.replaceAllWithInterpolation(this.getNewReleaseTitle(), variables, unresolvedVariables, freezeEvenIfUnresolved));
        this.freezeTemplateIdVariable(variables, unresolvedVariables, freezeEvenIfUnresolved);
        this.freezeFolderIdVariable(variables, unresolvedVariables, freezeEvenIfUnresolved);
        this.getTemplateVariables().forEach(variable -> {
            Object value = variable.getValue();
            value = variable.isPassword() ? VariableHelper.replaceAll(value, passwordVariables, unresolvedVariables, freezeEvenIfUnresolved) : VariableHelper.replaceAllWithInterpolation(value, variables, unresolvedVariables, freezeEvenIfUnresolved);
            variable.setUntypedValue(value);
            changes.update((ConfigurationItem)variable);
        });
        Set<String> resolvedTags = VariableHelper.replaceAllWithInterpolation(this.getReleaseTags(), variables, unresolvedVariables, freezeEvenIfUnresolved);
        this.setReleaseTags(resolvedTags.stream().filter(Strings::isNotBlank).collect(Collectors.toSet()));
        changes.update((ConfigurationItem)this);
        return unresolvedVariables;
    }

    private void freezeTemplateIdVariable(Map<String, ValueWithInterpolation> variables, Set<String> unresolvedVariables, boolean freezeEvenIfUnresolved) {
        String frozenTemplateId;
        if (VariableHelper.containsOnlyVariable(this.getTemplateId())) {
            this.setTemplateIdVariable(this.getTemplateId());
        }
        if ((frozenTemplateId = VariableHelper.replaceAllWithInterpolation(this.getTemplateId(), variables, unresolvedVariables, freezeEvenIfUnresolved)) != null) {
            frozenTemplateId = frozenTemplateId.replace('-', '/');
        }
        this.setTemplateId(frozenTemplateId);
    }

    private void freezeFolderIdVariable(Map<String, ValueWithInterpolation> variables, Set<String> unresolvedVariables, boolean freezeEvenIfUnresolved) {
        String frozenFolderId = VariableHelper.replaceAllWithInterpolation(this.getFolderId(), variables, unresolvedVariables, freezeEvenIfUnresolved);
        if (Strings.isNotEmpty((String)frozenFolderId)) {
            frozenFolderId = Ids.toDomainId((String)frozenFolderId);
        }
        this.setFolderId(frozenFolderId);
    }

    @Override
    protected boolean shouldFreezeVariableMapping(CiProperty property) {
        return !"output".equals(property.getDescriptor().getCategory());
    }

    @Override
    public List<UsagePoint> getVariableUsages() {
        ArrayList<UsagePoint> usagePoints = new ArrayList<UsagePoint>(super.getVariableUsages());
        usagePoints.add(new PropertyUsagePoint((ConfigurationItem)this, "newReleaseTitle"));
        usagePoints.add(new PropertyUsagePoint((ConfigurationItem)this, TEMPLATE_ID));
        usagePoints.add(new PropertyUsagePoint((ConfigurationItem)this, FOLDER_ID));
        usagePoints.add(new PropertyUsagePoint((ConfigurationItem)this, CREATED_RELEASE_ID));
        for (int i = 0; i < this.getTemplateVariables().size(); ++i) {
            usagePoints.add(new PropertyUsagePoint((ConfigurationItem)this, String.format("templateVariables[%s].value", i)));
        }
        return usagePoints;
    }

    @PublicApiMember
    public String getNewReleaseTitle() {
        return this.newReleaseTitle;
    }

    @PublicApiMember
    public void setNewReleaseTitle(String newReleaseTitle) {
        this.newReleaseTitle = newReleaseTitle;
    }

    @PublicApiMember
    public String getTemplateId() {
        return this.templateId;
    }

    @PublicApiMember
    public void setTemplateId(String templateId) {
        this.templateId = templateId;
    }

    @PublicApiMember
    public String getFolderId() {
        return this.folderId;
    }

    @PublicApiMember
    public void setFolderId(String folderId) {
        this.folderId = folderId;
    }

    @PublicApiMember
    public String getCreatedReleaseId() {
        return this.createdReleaseId;
    }

    public void setCreatedReleaseId(String createdReleaseId) {
        this.createdReleaseId = createdReleaseId;
    }

    @PublicApiMember
    public List<Variable> getTemplateVariables() {
        return this.templateVariables;
    }

    @PublicApiMember
    public void setTemplateVariables(List<Variable> variables) {
        this.templateVariables = variables;
    }

    @PublicApiMember
    public boolean getStartRelease() {
        return this.startRelease;
    }

    @PublicApiMember
    public void setStartRelease(boolean startRelease) {
        this.startRelease = startRelease;
    }

    @PublicApiMember
    public Set<String> getReleaseTags() {
        return this.releaseTags;
    }

    @PublicApiMember
    public void setReleaseTags(Set<String> releaseTags) {
        this.releaseTags = releaseTags;
    }

    @PublicApiMember
    public RiskProfile getRiskProfile() {
        return this.riskProfile;
    }

    @PublicApiMember
    public void setRiskProfile(RiskProfile riskProfile) {
        this.riskProfile = riskProfile;
    }

    @PublicApiMember
    public boolean getWaitForRelease() {
        return this.waitForRelease;
    }

    @PublicApiMember
    public void setWaitForRelease(boolean waitForRelease) {
        this.waitForRelease = waitForRelease;
    }

    public String getTemplateIdVariable() {
        return this.templateIdVariable;
    }

    public void setTemplateIdVariable(String templateIdVariable) {
        this.templateIdVariable = templateIdVariable;
    }

    public Map<String, Variable> getTemplateVariablesByKeys() {
        return VariableHelper.indexByKey(this.templateVariables);
    }
}

