/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.domain.runner;

import com.xebialabs.deployit.plugin.api.validation.ExtendedValidationContext;
import com.xebialabs.deployit.plugin.api.validation.Rule;
import com.xebialabs.deployit.plugin.api.validation.ValidationContext;
import com.xebialabs.deployit.plugin.api.validation.Validator;
import com.xebialabs.xlrelease.domain.runner.RemoteRunnerRegistrySettings;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@Retention(value=RetentionPolicy.RUNTIME)
@Rule(clazz=RunnerRegistrySettingsValidator.class, type="remoteRunnerRegistrySettings")
@Target(value={ElementType.TYPE})
@interface RegistrySettingsValidator {

    public static class RunnerRegistrySettingsValidator
    implements Validator<RemoteRunnerRegistrySettings> {
        public void validate(RemoteRunnerRegistrySettings remoteRunnerRegistrySettings, ValidationContext context) {
            ExtendedValidationContext extendedContext = (ExtendedValidationContext)context;
            this.validateBaseUrlAtBeginningOfMapping(remoteRunnerRegistrySettings, extendedContext);
            this.validateImageMappingsAreNotTheSame(remoteRunnerRegistrySettings, extendedContext);
            this.validateMappingsDontStartOrEndWithSlash(remoteRunnerRegistrySettings, extendedContext);
        }

        private void validateBaseUrlAtBeginningOfMapping(RemoteRunnerRegistrySettings remoteRunnerRegistrySettings, ExtendedValidationContext extendedContext) {
            Set mappings = remoteRunnerRegistrySettings.imageUrlMappings().entrySet().stream().flatMap(entry -> Stream.of((String)entry.getKey(), (String)entry.getValue())).collect(Collectors.toSet());
            for (String baseUrl : remoteRunnerRegistrySettings.getBaseUrls()) {
                boolean isValid = false;
                for (String mapping : mappings) {
                    if (!mapping.startsWith(baseUrl)) continue;
                    isValid = true;
                    break;
                }
                if (isValid) continue;
                extendedContext.error("Base URL '%s' must be an beginning of at least one image URL mapping", new Object[]{baseUrl});
            }
        }

        private void validateImageMappingsAreNotTheSame(RemoteRunnerRegistrySettings remoteRunnerRegistrySettings, ExtendedValidationContext extendedContext) {
            remoteRunnerRegistrySettings.imageUrlMappings().entrySet().stream().filter(entry -> ((String)entry.getKey()).equals(entry.getValue())).forEach(entry -> extendedContext.error("Image URL mapping '%s' cannot map to itself", new Object[]{entry.getKey()}));
        }

        private void validateMappingsDontStartOrEndWithSlash(RemoteRunnerRegistrySettings remoteRunnerRegistrySettings, ExtendedValidationContext extendedContext) {
            remoteRunnerRegistrySettings.imageUrlMappings().entrySet().stream().flatMap(entry -> Stream.of((String)entry.getKey(), (String)entry.getValue())).filter(mapping -> mapping.startsWith("/") || mapping.endsWith("/")).forEach(entry -> extendedContext.error("Image URL mapping '%s' cannot start or end with a '/' character", new Object[]{entry}));
        }
    }
}

