/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.domain.versioning.ascode.validation;

import com.xebialabs.xlplatform.documentation.PublicApiRef;
import com.xebialabs.xlrelease.domain.versioning.ascode.validation.ExternalDependencyReportMessage;
import com.xebialabs.xlrelease.domain.versioning.ascode.validation.ValidationMessage;
import com.xebialabs.xlrelease.domain.versioning.ascode.validation.ValidationReportMessage;
import com.xebialabs.xlrelease.domain.versioning.ascode.validation.ValidationReportMessageUtil;
import java.util.ArrayList;
import java.util.List;

@PublicApiRef
public class ValidationReport {
    private List<ValidationReportMessage> warnings = new ArrayList<ValidationReportMessage>();
    private List<ValidationReportMessage> errors = new ArrayList<ValidationReportMessage>();

    public List<ValidationReportMessage> getWarnings() {
        return this.warnings;
    }

    public void setWarnings(List<ValidationReportMessage> warnings) {
        this.warnings = warnings;
    }

    public List<ValidationReportMessage> getErrors() {
        return this.errors;
    }

    public void setErrors(List<ValidationReportMessage> errors) {
        this.errors = errors;
    }

    public static ValidationReport messagesToReport(List<ValidationMessage> messages) {
        ValidationReport report = new ValidationReport();
        report.getWarnings().addAll(ValidationReport.filterAndConvert("WARNING", messages));
        report.getErrors().addAll(ValidationReport.filterAndConvert("ERROR", messages));
        return report;
    }

    public static ValidationReport createWarningReport(List<ValidationReportMessage> messages) {
        ValidationReport report = new ValidationReport();
        report.getWarnings().addAll(messages);
        return report;
    }

    private static List<ExternalDependencyReportMessage> filterAndConvert(String level, List<ValidationMessage> messages) {
        ArrayList<ExternalDependencyReportMessage> filteredMessageList = new ArrayList<ExternalDependencyReportMessage>();
        for (ValidationMessage vm : messages) {
            if (!level.equals(vm.getMessageLevel())) continue;
            filteredMessageList.add(ValidationReportMessageUtil.validationMessageToReportMessage(vm));
        }
        return filteredMessageList;
    }
}

