/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.risk.domain.riskassessors;

import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.xlrelease.domain.PlanItem;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.risk.domain.RiskAssessment;
import com.xebialabs.xlrelease.risk.domain.RiskProfile;
import com.xebialabs.xlrelease.risk.domain.riskassessors.PlanItemDueDateRiskAssessor;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

@Metadata(label="MoreThanOneTaskOverDueRiskAssessor", versioned=false)
public class MoreThanOneTaskOverDueRiskAssessor
extends PlanItemDueDateRiskAssessor {
    private static final String OVERDUE_TASKS_HEADLINE = "Release has overdue tasks";

    @Override
    public RiskAssessment execute(Release release, RiskProfile riskProfile) {
        RiskAssessment assessment = new RiskAssessment();
        assessment.setRiskAssessorId(this.getId());
        List<Task> overdueTasks = release.getActiveTasks().stream().filter(PlanItem::isOverdue).collect(Collectors.toList());
        ArrayList<String> messages = new ArrayList<String>();
        if (overdueTasks.size() > 1) {
            assessment.setHeadline(OVERDUE_TASKS_HEADLINE);
            assessment.setScore(riskProfile.getValueFor(this.getType()));
            overdueTasks.forEach(task -> messages.add(this.formatMessage((PlanItem)task)));
        } else {
            assessment.setScore(0);
            assessment.setHeadline("Release is on track");
        }
        assessment.setMessages(messages);
        return assessment;
    }
}

