/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.bytecode.enhance.internal.bytebuddy;

import java.io.IOException;
import java.util.HashMap;
import java.util.Objects;
import net.bytebuddy.dynamic.ClassFileLocator;

final class OverridingClassFileLocator
implements ClassFileLocator {
    private final ThreadLocal<HashMap<String, ClassFileLocator.Resolution>> registeredResolutions = ThreadLocal.withInitial(() -> new HashMap());
    private final ClassFileLocator parent;

    OverridingClassFileLocator(ClassFileLocator parent) {
        this.parent = Objects.requireNonNull(parent);
    }

    public ClassFileLocator.Resolution locate(String name) throws IOException {
        ClassFileLocator.Resolution resolution = this.getLocalMap().get(name);
        if (resolution != null) {
            return resolution;
        }
        return this.parent.locate(name);
    }

    private HashMap<String, ClassFileLocator.Resolution> getLocalMap() {
        return this.registeredResolutions.get();
    }

    public void close() {
        this.registeredResolutions.remove();
    }

    void put(String className, ClassFileLocator.Resolution.Explicit explicit) {
        this.getLocalMap().put(className, (ClassFileLocator.Resolution)explicit);
    }

    void remove(String className) {
        this.getLocalMap().remove(className);
    }
}

