/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plumbing;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IgnoreUrlFilter
implements Filter {
    private static final Logger LOG = LoggerFactory.getLogger(IgnoreUrlFilter.class);
    private static final Supplier<Stream<String>> IGNORED_URLS = () -> Stream.of("angular-gantt.js.map", "ctrl.frameSrc");

    public void init(FilterConfig filterConfig) {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (request instanceof HttpServletRequest) {
            String requestURI = ((HttpServletRequest)request).getRequestURI();
            if (IGNORED_URLS.get().anyMatch(requestURI::contains)) {
                LOG.debug("Request to [{}] has been ignored", (Object)requestURI);
                return;
            }
        }
        chain.doFilter(request, response);
    }

    public void destroy() {
    }
}

