/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service.sse;

import com.xebialabs.xlrelease.domain.distributed.events.DistributedSSEEvent;
import com.xebialabs.xlrelease.domain.distributed.events.DistributedSendSSEEvent;
import com.xebialabs.xlrelease.domain.distributed.events.DistributedSubscribeSSEEvent;
import com.xebialabs.xlrelease.domain.distributed.events.DistributedUnsubscribeAllSSEEvent;
import com.xebialabs.xlrelease.domain.distributed.events.DistributedUnsubscribeSSEEvent;
import com.xebialabs.xlrelease.domain.distributed.events.DistributedXLReleaseEvent;
import com.xebialabs.xlrelease.events.AsyncSubscribe;
import com.xebialabs.xlrelease.events.EventListener;
import com.xebialabs.xlrelease.repository.SSERepository;
import com.xebialabs.xlrelease.service.BroadcastService;
import com.xebialabs.xlrelease.service.SseService;
import com.xebialabs.xlrelease.user.User;
import jakarta.ws.rs.sse.SseEventSink;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;
import scala.MatchError;
import scala.reflect.ScalaSignature;

@Service
@EventListener
@ConditionalOnProperty(name={"xl.features.sse.enabled"}, havingValue="true")
@ScalaSignature(bytes="\u0006\u0005\u0005-c\u0001B\u0007\u000f\u0001eA\u0001\u0002\n\u0001\u0003\u0002\u0003\u0006I!\n\u0005\tW\u0001\u0011\t\u0011)A\u0005Y!)q\u0006\u0001C\u0001a!)Q\u0007\u0001C!m!)q\t\u0001C!\u0011\")q\t\u0001C!-\")!\f\u0001C!7\")!\f\u0001C!;\")\u0001\r\u0001C!C\")1\r\u0001C!I\")!\u000e\u0001C!W\")\u0001\u000f\u0001C\u0001c\n\tB)\u001a4bk2$8k]3TKJ4\u0018nY3\u000b\u0005=\u0001\u0012aA:tK*\u0011\u0011CE\u0001\bg\u0016\u0014h/[2f\u0015\t\u0019B#A\u0005yYJ,G.Z1tK*\u0011QCF\u0001\nq\u0016\u0014\u0017.\u00197bENT\u0011aF\u0001\u0004G>l7\u0001A\n\u0004\u0001i\u0001\u0003CA\u000e\u001f\u001b\u0005a\"\"A\u000f\u0002\u000bM\u001c\u0017\r\\1\n\u0005}a\"AB!osJ+g\r\u0005\u0002\"E5\t\u0001#\u0003\u0002$!\tQ1k]3TKJ4\u0018nY3\u0002\u001bM\u001cXMU3q_NLGo\u001c:z!\t1\u0013&D\u0001(\u0015\tA##\u0001\u0006sKB|7/\u001b;pefL!AK\u0014\u0003\u001bM\u001bVIU3q_NLGo\u001c:z\u0003A\u0011'o\\1eG\u0006\u001cHoU3sm&\u001cW\r\u0005\u0002\"[%\u0011a\u0006\u0005\u0002\u0011\u0005J|\u0017\rZ2bgR\u001cVM\u001d<jG\u0016\fa\u0001P5oSRtDcA\u00194iA\u0011!\u0007A\u0007\u0002\u001d!)Ae\u0001a\u0001K!)1f\u0001a\u0001Y\u0005\u00192/\u001e2tGJL'-Z+tKJ$vnU5oWR\u0011qG\u000f\t\u00037aJ!!\u000f\u000f\u0003\tUs\u0017\u000e\u001e\u0005\u0006w\u0011\u0001\r\u0001P\u0001\u0005g&t7\u000e\u0005\u0002>\u000b6\taH\u0003\u0002\u0010\u007f)\u0011\u0001)Q\u0001\u0003eNT!AQ\"\u0002\u0005]\u001c(\"\u0001#\u0002\u000f)\f7.\u0019:uC&\u0011aI\u0010\u0002\r'N,WI^3oiNKgn[\u0001\u0015gV\u00147o\u0019:jE\u0016$v\u000e]5d)>,6/\u001a:\u0015\u0005]J\u0005\"\u0002&\u0006\u0001\u0004Y\u0015!\u0002;pa&\u001c\u0007C\u0001'T\u001d\ti\u0015\u000b\u0005\u0002O95\tqJ\u0003\u0002Q1\u00051AH]8pizJ!A\u0015\u000f\u0002\rA\u0013X\rZ3g\u0013\t!VK\u0001\u0004TiJLgn\u001a\u0006\u0003%r!2aN,Y\u0011\u0015Qe\u00011\u0001L\u0011\u0015If\u00011\u0001L\u0003!)8/\u001a:oC6,\u0017AF;ogV\u00147o\u0019:jE\u0016$v\u000e]5d)>,6/\u001a:\u0015\u0005]b\u0006\"\u0002&\b\u0001\u0004YEcA\u001c_?\")!\n\u0003a\u0001\u0017\")\u0011\f\u0003a\u0001\u0017\u0006\u0019RO\\:vEN\u001c'/\u001b2f\u00032dWk]3sgR\u0011qG\u0019\u0005\u0006\u0015&\u0001\raS\u0001\ng\u0016tG-\u0012<f]R$BaN3gQ\")!J\u0003a\u0001\u0017\")qM\u0003a\u0001\u0017\u0006IQM^3oi:\u000bW.\u001a\u0005\u0006S*\u0001\raS\u0001\ba\u0006LHn\\1e\u00039A\u0017m]!di&4X-V:feN$\"\u0001\\8\u0011\u0005mi\u0017B\u00018\u001d\u0005\u001d\u0011un\u001c7fC:DQAS\u0006A\u0002-\u000bqa\u001c8Fm\u0016tG\u000f\u0006\u00028e\")1\u000f\u0004a\u0001i\u0006)QM^3oiB\u0011Q\u000f`\u0007\u0002m*\u0011q\u000f_\u0001\u0007KZ,g\u000e^:\u000b\u0005eT\u0018a\u00033jgR\u0014\u0018NY;uK\u0012T!a\u001f\n\u0002\r\u0011|W.Y5o\u0013\tihOA\nESN$(/\u001b2vi\u0016$7kU#Fm\u0016tG\u000f\u000b\u0002\r\u007fB!\u0011\u0011AA\u0003\u001b\t\t\u0019A\u0003\u0002x%%!\u0011qAA\u0002\u00059\t5/\u001f8d'V\u00147o\u0019:jE\u0016D3\u0001AA\u0006!\u0011\ti!a\u0007\u000e\u0005\u0005=!\u0002BA\t\u0003'\t!b\u001d;fe\u0016|G/\u001f9f\u0015\u0011\t)\"a\u0006\u0002\u001fM\u0004(/\u001b8hMJ\fW.Z<pe.T!!!\u0007\u0002\u0007=\u0014x-\u0003\u0003\u0002\u001e\u0005=!aB*feZL7-\u001a\u0015\u0004\u0001\u0005\u0005\u0002\u0003BA\u0001\u0003GIA!!\n\u0002\u0004\tiQI^3oi2K7\u000f^3oKJD3\u0002AA\u0015\u0003{\ty$!\u0012\u0002HA!\u00111FA\u001d\u001b\t\tiC\u0003\u0003\u00020\u0005E\u0012!C2p]\u0012LG/[8o\u0015\u0011\t\u0019$!\u000e\u0002\u001b\u0005,Ho\\2p]\u001aLw-\u001e:f\u0015\u0011\t9$a\u0005\u0002\t\t|w\u000e^\u0005\u0005\u0003w\tiCA\u000bD_:$\u0017\u000e^5p]\u0006dwJ\u001c)s_B,'\u000f^=\u0002\t9\fW.\u001a\u0017\u0003\u0003\u0003\n#!a\u0011\u0002/adgFZ3biV\u0014Xm\u001d\u0018tg\u0016tSM\\1cY\u0016$\u0017a\u00035bm&twMV1mk\u0016\f#!!\u0013\u0002\tQ\u0014X/\u001a")
public class DefaultSseService
implements SseService {
    private final SSERepository sseRepository;
    private final BroadcastService broadcastService;

    @Override
    public void subscribeUserToSink(SseEventSink sink) {
        String username = User.AUTHENTICATED_USER.getName();
        this.sseRepository.addUserToSink(username, sink);
    }

    @Override
    public void subscribeTopicToUser(String topic) {
        String username = User.AUTHENTICATED_USER.getName();
        this.subscribeTopicToUser(topic, username);
    }

    @Override
    public void subscribeTopicToUser(String topic, String username) {
        this.broadcastService.broadcast((DistributedXLReleaseEvent)new DistributedSubscribeSSEEvent(topic, username), true);
    }

    @Override
    public void unsubscribeTopicToUser(String topic) {
        String username = User.AUTHENTICATED_USER.getName();
        this.unsubscribeTopicToUser(topic, username);
    }

    @Override
    public void unsubscribeTopicToUser(String topic, String username) {
        this.broadcastService.broadcast((DistributedXLReleaseEvent)new DistributedUnsubscribeSSEEvent(topic, username), true);
    }

    @Override
    public void unsubscribeAllUsers(String topic) {
        this.broadcastService.broadcast((DistributedXLReleaseEvent)new DistributedUnsubscribeAllSSEEvent(topic), true);
    }

    @Override
    public void sendEvent(String topic, String eventName, String payload) {
        this.broadcastService.broadcast((DistributedXLReleaseEvent)new DistributedSendSSEEvent(topic, eventName, payload), true);
    }

    @Override
    public boolean hasActiveUsers(String topic) {
        return this.sseRepository.getUsers(topic).nonEmpty();
    }

    @AsyncSubscribe
    public void onEvent(DistributedSSEEvent event) {
        DistributedSSEEvent distributedSSEEvent = event;
        if (distributedSSEEvent instanceof DistributedSubscribeSSEEvent) {
            DistributedSubscribeSSEEvent distributedSubscribeSSEEvent = (DistributedSubscribeSSEEvent)distributedSSEEvent;
            String topic = distributedSubscribeSSEEvent.topic();
            String username = distributedSubscribeSSEEvent.user();
            this.sseRepository.addTopicToUser(topic, username);
            return;
        }
        if (distributedSSEEvent instanceof DistributedUnsubscribeSSEEvent) {
            DistributedUnsubscribeSSEEvent distributedUnsubscribeSSEEvent = (DistributedUnsubscribeSSEEvent)distributedSSEEvent;
            String topic = distributedUnsubscribeSSEEvent.topic();
            String username = distributedUnsubscribeSSEEvent.user();
            this.sseRepository.removeTopicToUser(topic, username);
            return;
        }
        if (distributedSSEEvent instanceof DistributedUnsubscribeAllSSEEvent) {
            DistributedUnsubscribeAllSSEEvent distributedUnsubscribeAllSSEEvent = (DistributedUnsubscribeAllSSEEvent)distributedSSEEvent;
            String topic = distributedUnsubscribeAllSSEEvent.topic();
            this.sseRepository.removeAllUsersFromTopic(topic);
            return;
        }
        if (distributedSSEEvent instanceof DistributedSendSSEEvent) {
            DistributedSendSSEEvent distributedSendSSEEvent = (DistributedSendSSEEvent)distributedSSEEvent;
            String topic = distributedSendSSEEvent.topic();
            String eventName = distributedSendSSEEvent.eventName();
            String payload = distributedSendSSEEvent.payload();
            this.sseRepository.sendEventToSink(topic, eventName, payload);
            return;
        }
        throw new MatchError((Object)distributedSSEEvent);
    }

    public DefaultSseService(SSERepository sseRepository, BroadcastService broadcastService) {
        this.sseRepository = sseRepository;
        this.broadcastService = broadcastService;
        SseService.$init$(this);
    }
}

