/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.smi;

import java.io.IOException;
import java.io.OutputStream;
import org.snmp4j.asn1.BER;
import org.snmp4j.asn1.BERInputStream;
import org.snmp4j.smi.AbstractVariable;
import org.snmp4j.smi.AssignableFromInteger;
import org.snmp4j.smi.AssignableFromString;
import org.snmp4j.smi.OID;

public class Integer32
extends AbstractVariable
implements AssignableFromInteger,
AssignableFromString {
    private static final long serialVersionUID = 5046132399890132416L;
    private int value = 0;

    public Integer32() {
    }

    public Integer32(int n) {
        this.setValue(n);
    }

    public void encodeBER(OutputStream outputStream) throws IOException {
        BER.encodeInteger(outputStream, (byte)2, this.value);
    }

    public void decodeBER(BERInputStream bERInputStream) throws IOException {
        BER.MutableByte mutableByte = new BER.MutableByte();
        int n = BER.decodeInteger(bERInputStream, mutableByte);
        if (mutableByte.getValue() != 2) {
            throw new IOException("Wrong type encountered when decoding Counter: " + mutableByte.getValue());
        }
        this.setValue(n);
    }

    public int getSyntax() {
        return 2;
    }

    public int hashCode() {
        return this.value;
    }

    public int getBERLength() {
        if (this.value < 128 && this.value >= -128) {
            return 3;
        }
        if (this.value < 32768 && this.value >= Short.MIN_VALUE) {
            return 4;
        }
        if (this.value < 0x800000 && this.value >= -8388608) {
            return 5;
        }
        return 6;
    }

    public boolean equals(Object object) {
        if (object instanceof Integer32) {
            return ((Integer32)object).value == this.value;
        }
        return false;
    }

    public int compareTo(Object object) {
        return this.value - ((Integer32)object).value;
    }

    public String toString() {
        return Integer.toString(this.value);
    }

    public final void setValue(String string) {
        this.value = Integer.parseInt(string);
    }

    public final void setValue(int n) {
        this.value = n;
    }

    public final int getValue() {
        return this.value;
    }

    public Object clone() {
        return new Integer32(this.value);
    }

    public final int toInt() {
        return this.getValue();
    }

    public final long toLong() {
        return this.getValue();
    }

    public OID toSubIndex(boolean bl) {
        return new OID(new int[]{this.value});
    }

    public void fromSubIndex(OID oID, boolean bl) {
        this.setValue(oID.get(0));
    }
}

