/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.vault.core;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.util.Assert;
import org.springframework.vault.client.VaultResponses;
import org.springframework.vault.core.HttpStatusUtil;
import org.springframework.vault.core.KeyValueUtilities;
import org.springframework.vault.core.ReactiveVaultKeyValue2Accessor;
import org.springframework.vault.core.ReactiveVaultKeyValueAccessor;
import org.springframework.vault.core.ReactiveVaultKeyValueMetadataOperations;
import org.springframework.vault.core.ReactiveVaultKeyValueMetadataTemplate;
import org.springframework.vault.core.ReactiveVaultOperations;
import org.springframework.vault.core.ReactiveVaultVersionedKeyValueOperations;
import org.springframework.vault.core.VersionedResponse;
import org.springframework.vault.support.VaultResponseSupport;
import org.springframework.vault.support.Versioned;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;

public class ReactiveVaultVersionedKeyValueTemplate
extends ReactiveVaultKeyValue2Accessor
implements ReactiveVaultVersionedKeyValueOperations {
    private final String path;

    public ReactiveVaultVersionedKeyValueTemplate(ReactiveVaultOperations reactiveVaultOperations, String path) {
        super(reactiveVaultOperations, path);
        this.path = path;
    }

    private static List<Integer> toVersionList(Versioned.Version[] versionsToDelete) {
        return Arrays.stream(versionsToDelete).filter(Versioned.Version::isVersioned).map(Versioned.Version::getVersion).collect(Collectors.toList());
    }

    public Mono<Versioned<Map<String, Object>>> get(String path, Versioned.Version version) {
        Assert.hasText((String)path, (String)"Path must not be empty");
        Assert.notNull((Object)version, (String)"Version must not be null");
        return this.doRead(path, version, Map.class).map(m -> Versioned.create((Map)m.getData(), m.getRequiredMetadata()));
    }

    @Override
    public <T> Mono<Versioned<T>> get(String path, Versioned.Version version, Class<T> responseType) {
        Assert.hasText((String)path, (String)"Path must not be empty");
        Assert.notNull((Object)version, (String)"Version must not be null");
        Assert.notNull(responseType, (String)"Response type must not be null");
        return this.doRead(path, version, responseType);
    }

    private <T> Mono<Versioned<T>> doRead(String path, Versioned.Version version, Class<T> responseType) {
        String secretPath = version.isVersioned() ? String.format("%s?version=%d", this.createDataPath(path), version.getVersion()) : this.createDataPath(path);
        Mono<VersionedResponse> versionedResponseMono = this.doReadVersioned(secretPath);
        return versionedResponseMono.map(response -> {
            VaultResponseSupport data = (VaultResponseSupport)response.getRequiredData();
            Versioned.Metadata metadata = KeyValueUtilities.getMetadata(data.getMetadata());
            Object body = this.deserialize((JsonNode)data.getRequiredData(), responseType);
            return Versioned.create(body, metadata);
        });
    }

    @Override
    public Mono<Versioned.Metadata> put(String path, Object body) {
        Assert.hasText((String)path, (String)"Path must not be empty");
        LinkedHashMap<String, Object> data = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, Integer> requestOptions = new LinkedHashMap<String, Integer>();
        if (body instanceof Versioned) {
            Versioned versioned = (Versioned)body;
            data.put("data", versioned.getData());
            data.put("options", requestOptions);
            requestOptions.put("cas", versioned.getVersion().getVersion());
        } else {
            data.put("data", body);
        }
        return this.doWrite(this.createDataPath(path), data).map(VaultResponseSupport::getRequiredData).map(KeyValueUtilities::getMetadata).switchIfEmpty(Mono.error((Throwable)new IllegalStateException("VaultVersionedKeyValueOperations cannot be used with a Key-Value version 1 mount")));
    }

    @Override
    public Mono<Void> delete(String path, Versioned.Version ... versionsToDelete) {
        Assert.hasText((String)path, (String)"Path must not be empty");
        Assert.noNullElements((Object[])versionsToDelete, (String)"Versions must not be null");
        if (versionsToDelete.length == 0) {
            return this.delete(path);
        }
        List<Integer> versions = ReactiveVaultVersionedKeyValueTemplate.toVersionList(versionsToDelete);
        return this.doWrite(this.createBackendPath("delete", path), Collections.singletonMap("versions", versions)).then().log();
    }

    @Override
    public Mono<Void> undelete(String path, Versioned.Version ... versionsToDelete) {
        Assert.hasText((String)path, (String)"Path must not be empty");
        Assert.noNullElements((Object[])versionsToDelete, (String)"Versions must not be null");
        List<Integer> versions = ReactiveVaultVersionedKeyValueTemplate.toVersionList(versionsToDelete);
        return this.doWrite(this.createBackendPath("undelete", path), Collections.singletonMap("versions", versions)).then();
    }

    @Override
    public Mono<Void> destroy(String path, Versioned.Version ... versionsToDelete) {
        Assert.hasText((String)path, (String)"Path must not be empty");
        Assert.noNullElements((Object[])versionsToDelete, (String)"Versions must not be null");
        List<Integer> versions = ReactiveVaultVersionedKeyValueTemplate.toVersionList(versionsToDelete);
        return this.doWrite(this.createBackendPath("destroy", path), Collections.singletonMap("versions", versions)).then();
    }

    @Override
    public ReactiveVaultKeyValueMetadataOperations opsForKeyValueMetadata() {
        return new ReactiveVaultKeyValueMetadataTemplate(this.reactiveVaultOperations, this.path);
    }

    <T> Mono<VersionedResponse> doReadVersioned(String path) {
        Function toEntity = cr -> cr.toEntity(VersionedResponse.class);
        ReactiveVaultKeyValueAccessor.ResponseFunction defaults = new ReactiveVaultKeyValueAccessor.ResponseFunction(toEntity);
        Function responseFunction = clientResponse -> {
            if (HttpStatusUtil.isNotFound(clientResponse.statusCode())) {
                return clientResponse.bodyToMono(String.class).flatMap(it -> {
                    if (it.contains("deletion_time")) {
                        return Mono.justOrEmpty((Object)VaultResponses.unwrap(it, VersionedResponse.class));
                    }
                    return Mono.empty();
                });
            }
            return defaults.apply((ClientResponse)clientResponse);
        };
        return this.doRead((WebClient webClient) -> webClient.get().uri(path, new Object[0]), responseFunction);
    }
}

