/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.booter.local;

import com.xebialabs.deployit.booter.local.DelegateRegistry;
import com.xebialabs.deployit.booter.local.LocalDescriptor;
import com.xebialabs.deployit.booter.local.LocalDescriptorRegistryId;
import com.xebialabs.deployit.booter.local.SealedDescriptorHierarchy;
import com.xebialabs.deployit.booter.local.Verifications;
import com.xebialabs.deployit.booter.local.utils.CheckUtils;
import com.xebialabs.deployit.plugin.api.reflect.BaseDescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistryId;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalDescriptorRegistry
extends BaseDescriptorRegistry {
    public static final int ORDER = -1;
    private static Logger logger = LoggerFactory.getLogger(LocalDescriptorRegistry.class);
    public static final DescriptorRegistryId LOCAL_ID = new LocalDescriptorRegistryId();
    private final Map<Type, Descriptor> descriptors = new HashMap<Type, Descriptor>();
    private final SealedDescriptorHierarchy subtypes = new SealedDescriptorHierarchy();

    protected LocalDescriptorRegistry() {
        super(LOCAL_ID);
    }

    public void register(Descriptor descriptor) {
        CheckUtils.checkState(!this.descriptors.containsKey(descriptor.getType()), "The type [%s] is already registered with [%s].", descriptor.getType(), this.getId());
        logger.debug("Registered ConfigurationItem: {}", (Object)descriptor);
        this.descriptors.put(descriptor.getType(), descriptor);
    }

    public void registerSubtype(Type supertype, Type subtype) {
        CheckUtils.checkState(!supertype.equals((Object)subtype), "Cannot register [%s] as its own subtype.", supertype);
        this.subtypes.registerSubType(supertype, subtype);
    }

    public boolean isLocal() {
        return true;
    }

    public boolean isDefault() {
        return true;
    }

    public int getOrder() {
        return -1;
    }

    public Collection<Descriptor> getDescriptors() {
        return Collections.unmodifiableCollection(this.descriptors.values());
    }

    public Collection<Type> getSubtypes(Type supertype) {
        return Collections.unmodifiableCollection(this.subtypes.getSubtypes(supertype));
    }

    public Descriptor getDescriptor(Type type) {
        CheckUtils.checkState(!this.descriptors.isEmpty(), "DescriptorRegistry not booted", new Object[0]);
        CheckUtils.checkArgument(this.exists(type), "Unknown type [%s]", type);
        return this.descriptors.get(type);
    }

    public boolean exists(Type type) {
        return this.descriptors.containsKey(type);
    }

    public void verifyTypes() {
        Verifications verifications = new Verifications();
        DelegateRegistry.verify(verifications);
        this.getDescriptors().stream().filter(input -> !input.isVirtual()).forEach(d -> ((LocalDescriptor)d).verify(verifications));
        verifications.done();
    }
}

