/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.ascode.service;

import com.xebialabs.ascode.exception.AsCodeException;
import com.xebialabs.ascode.exception.AsCodeException$;
import com.xebialabs.ascode.yaml.model.CiSpec;
import com.xebialabs.ascode.yaml.model.Definition;
import com.xebialabs.ascode.yaml.model.Spec;
import com.xebialabs.ascode.yaml.model.permission.PermissionsSpec;
import com.xebialabs.xlplatform.coc.dto.SCMTraceabilityData;
import com.xebialabs.xlrelease.ascode.service.ImportIncludes;
import com.xebialabs.xlrelease.ascode.service.ImportResult;
import com.xebialabs.xlrelease.ascode.service.spec.CiSpecInterpreter;
import com.xebialabs.xlrelease.ascode.service.spec.PermissionsSpecInterpreter;
import com.xebialabs.xlrelease.versioning.ascode.ImportValidator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Option;
import scala.reflect.ScalaSignature;

@Service
@Autowired
@ScalaSignature(bytes="\u0006\u000554A!\u0002\u0004\u0001#!A\u0001\u0004\u0001B\u0001B\u0003%\u0011\u0004\u0003\u0005 \u0001\t\u0005\t\u0015!\u0003!\u0011\u0015\u0019\u0003\u0001\"\u0001%\u0011\u0015I\u0003\u0001\"\u0001+\u00055IU\u000e]8siN+'O^5dK*\u0011q\u0001C\u0001\bg\u0016\u0014h/[2f\u0015\tI!\"\u0001\u0004bg\u000e|G-\u001a\u0006\u0003\u00171\t\u0011\u0002\u001f7sK2,\u0017m]3\u000b\u00055q\u0011!\u0003=fE&\fG.\u00192t\u0015\u0005y\u0011aA2p[\u000e\u00011C\u0001\u0001\u0013!\t\u0019b#D\u0001\u0015\u0015\u0005)\u0012!B:dC2\f\u0017BA\f\u0015\u0005\u0019\te.\u001f*fM\u0006Q1-[%na>\u0014H/\u001a:\u0011\u0005iiR\"A\u000e\u000b\u0005q1\u0011\u0001B:qK\u000eL!AH\u000e\u0003#\rK7\u000b]3d\u0013:$XM\u001d9sKR,'/A\nqKJl\u0017n]:j_:\u001c\u0018*\u001c9peR,'\u000f\u0005\u0002\u001bC%\u0011!e\u0007\u0002\u001b!\u0016\u0014X.[:tS>t7o\u00159fG&sG/\u001a:qe\u0016$XM]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007\u0015:\u0003\u0006\u0005\u0002'\u00015\ta\u0001C\u0003\u0019\u0007\u0001\u0007\u0011\u0004C\u0003 \u0007\u0001\u0007\u0001%A\u0004qe>\u001cWm]:\u0015\u000b-r3GP'\u0011\u0005\u0019b\u0013BA\u0017\u0007\u00051IU\u000e]8siJ+7/\u001e7u\u0011\u0015yC\u00011\u00011\u00039IW\u000e]8si&s7\r\\;eKN\u0004\"AJ\u0019\n\u0005I2!AD%na>\u0014H/\u00138dYV$Wm\u001d\u0005\u0006i\u0011\u0001\r!N\u0001\u000bI\u00164\u0017N\\5uS>t\u0007C\u0001\u001c=\u001b\u00059$B\u0001\u001d:\u0003\u0015iw\u000eZ3m\u0015\tQ4(\u0001\u0003zC6d'BA\u0005\r\u0013\titG\u0001\u0006EK\u001aLg.\u001b;j_:DQa\u0010\u0003A\u0002\u0001\u000bqa]2n\t\u0006$\u0018\rE\u0002\u0014\u0003\u000eK!A\u0011\u000b\u0003\r=\u0003H/[8o!\t!5*D\u0001F\u0015\t1u)A\u0002ei>T!\u0001S%\u0002\u0007\r|7M\u0003\u0002K\u0019\u0005Q\u0001\u0010\u001c9mCR4wN]7\n\u00051+%aE*D\u001bR\u0013\u0018mY3bE&d\u0017\u000e^=ECR\f\u0007\"\u0002(\u0005\u0001\u0004y\u0015!\u0003<bY&$\u0017\r^8s!\r\u0019\u0012\t\u0015\t\u0003#Vk\u0011A\u0015\u0006\u0003\u0013MS!\u0001\u0016\u0006\u0002\u0015Y,'o]5p]&tw-\u0003\u0002W%\ny\u0011*\u001c9peR4\u0016\r\\5eCR|'\u000f\u000b\u0002\u00011B\u0011\u0011\fY\u0007\u00025*\u00111\fX\u0001\u000bgR,'/Z8usB,'BA/_\u0003=\u0019\bO]5oO\u001a\u0014\u0018-\\3x_J\\'\"A0\u0002\u0007=\u0014x-\u0003\u0002b5\n91+\u001a:wS\u000e,\u0007F\u0001\u0001d!\t!7.D\u0001f\u0015\t1w-\u0001\u0006b]:|G/\u0019;j_:T!\u0001[5\u0002\u000f\u0019\f7\r^8ss*\u0011!\u000eX\u0001\u0006E\u0016\fgn]\u0005\u0003Y\u0016\u0014\u0011\"Q;u_^L'/\u001a3")
public class ImportService {
    private final CiSpecInterpreter ciImporter;
    private final PermissionsSpecInterpreter permissionsImporter;

    public ImportResult process(ImportIncludes importIncludes, Definition definition, Option<SCMTraceabilityData> scmData, Option<ImportValidator> validator) {
        Spec spec = definition.spec();
        if (spec instanceof CiSpec) {
            return this.ciImporter.importDefinition(importIncludes, definition, scmData, validator);
        }
        if (spec instanceof PermissionsSpec) {
            return this.permissionsImporter.importDefinition(importIncludes, definition, scmData, validator);
        }
        throw new AsCodeException(definition.spec().getClass() + " not supported in import service yet", AsCodeException$.MODULE$.$lessinit$greater$default$2());
    }

    public ImportService(CiSpecInterpreter ciImporter, PermissionsSpecInterpreter permissionsImporter) {
        this.ciImporter = ciImporter;
        this.permissionsImporter = permissionsImporter;
    }
}

