/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.plugins.remotecompletion.email;

import com.google.common.hash.Hashing;
import com.typesafe.config.Config;
import com.xebialabs.deployit.util.PasswordEncrypter;
import com.xebialabs.xlrelease.config.XlrConfig;
import com.xebialabs.xlrelease.plugins.remotecompletion.ci.CiUtils;
import com.xebialabs.xlrelease.plugins.remotecompletion.ci.ImapServer;
import com.xebialabs.xlrelease.repository.ConfigurationRepository;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SignatureService {
    private static final Logger logger = LoggerFactory.getLogger(SignatureService.class);
    private final ConfigurationRepository configurationRepository;
    private boolean isEmailCaseSensitiveEnabled = false;

    @Autowired
    public SignatureService(ConfigurationRepository configurationRepository, XlrConfig xlrConfig) {
        this.configurationRepository = configurationRepository;
        this.setEmailCaseSensitive(xlrConfig);
    }

    public Optional<String> createSignature(String fromEmail, String action, String taskId) {
        String _fromEmail = this.correctCase(fromEmail);
        logger.info("fromEmail={}, action={}, taskId={}", new Object[]{_fromEmail, action, taskId});
        return CiUtils.getImapServer(this.configurationRepository).map(ImapServer::getSecret).filter(s -> !s.isEmpty()).map(arg_0 -> ((PasswordEncrypter)PasswordEncrypter.getInstance()).decrypt(arg_0)).map(secret -> this.generateHash(_fromEmail + action + taskId + secret));
    }

    private String generateHash(CharSequence input) {
        return Hashing.sha512().hashString(input, StandardCharsets.UTF_8).toString();
    }

    private void setEmailCaseSensitive(XlrConfig xlrConfig) {
        if (xlrConfig == null || xlrConfig.getXl() == null || xlrConfig.getXl().getConfig("remote-completion") == null) {
            logger.warn("Email case sensitive not found in XLR configuration. Default is case not sensitive");
        } else {
            Config remoteCompletion = xlrConfig.getXl().getConfig("remote-completion");
            this.isEmailCaseSensitiveEnabled = remoteCompletion.hasPath("email-address-case-sensitive") && remoteCompletion.getBoolean("email-address-case-sensitive");
            logger.info("Email case sensitive is configured to: {}", (Object)this.isEmailCaseSensitiveEnabled);
        }
    }

    public String correctCase(String s) {
        if (!this.isEmailCaseSensitiveEnabled) {
            return s.toLowerCase();
        }
        return s;
    }
}

