/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.notifications.initialize;

import com.google.common.base.Strings;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.server.api.upgrade.Version;
import com.xebialabs.deployit.util.PasswordEncrypter;
import com.xebialabs.xlrelease.domain.BaseConfiguration;
import com.xebialabs.xlrelease.notifications.configuration.BasicSmtpAuthentication;
import com.xebialabs.xlrelease.notifications.configuration.NoSmtpAuthentication;
import com.xebialabs.xlrelease.notifications.configuration.SmtpAuthentication;
import com.xebialabs.xlrelease.notifications.configuration.SmtpServer;
import com.xebialabs.xlrelease.notifications.configuration.SmtpServer$;
import com.xebialabs.xlrelease.repository.ConfigurationRepository;
import com.xebialabs.xlrelease.repository.sql.persistence.configuration.ConfigurationPersistence;
import com.xebialabs.xlrelease.upgrade.common.BaseInitializingUpgrade;
import com.xebialabs.xlrelease.utils.CiHelper;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import org.codehaus.jettison.json.JSONObject;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import scala.Function0;
import scala.Option$;
import scala.Tuple3;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005}3AAB\u0004\u0001%!A1\u0005\u0001B\u0001B\u0003%A\u0005\u0003\u0005+\u0001\t\u0005\t\u0015!\u0003,\u0011\u0015)\u0004\u0001\"\u00017\u0011\u0015Q\u0005\u0001\"\u0011L\u0011\u00159\u0006\u0001\"\u0011Y\u0005}AFJU3mK\u0006\u001cX-\r\u00192aMkG\u000f]*feZ,'/\u00169he\u0006$WM\u001d\u0006\u0003\u0011%\t!\"\u001b8ji&\fG.\u001b>f\u0015\tQ1\"A\u0007o_RLg-[2bi&|gn\u001d\u0006\u0003\u00195\t\u0011\u0002\u001f7sK2,\u0017m]3\u000b\u00059y\u0011!\u0003=fE&\fG.\u00192t\u0015\u0005\u0001\u0012aA2p[\u000e\u00011c\u0001\u0001\u00147A\u0011A#G\u0007\u0002+)\u0011acF\u0001\u0007G>lWn\u001c8\u000b\u0005aY\u0011aB;qOJ\fG-Z\u0005\u00035U\u0011qCQ1tK&s\u0017\u000e^5bY&T\u0018N\\4Va\u001e\u0014\u0018\rZ3\u0011\u0005q\tS\"A\u000f\u000b\u0005yy\u0012!B:mMRR'\"\u0001\u0011\u0002\u0011\u001d\u0014\u0018N\u001f>mK\u0012L!AI\u000f\u0003\u000f1{wmZ5oO\u000692m\u001c8gS\u001e,(/\u0019;j_:\u0014V\r]8tSR|'/\u001f\t\u0003K!j\u0011A\n\u0006\u0003O-\t!B]3q_NLGo\u001c:z\u0013\tIcEA\fD_:4\u0017nZ;sCRLwN\u001c*fa>\u001c\u0018\u000e^8ss\u0006A2m\u001c8gS\u001e,(/\u0019;j_:\u0004VM]:jgR,gnY3\u0011\u00051\u001aT\"A\u0017\u000b\u00059z\u0013!D2p]\u001aLw-\u001e:bi&|gN\u0003\u00021c\u0005Y\u0001/\u001a:tSN$XM\\2f\u0015\t\u0011d%A\u0002tc2L!\u0001N\u0017\u00031\r{gNZ5hkJ\fG/[8o!\u0016\u00148/[:uK:\u001cW-\u0001\u0004=S:LGO\u0010\u000b\u0004oeR\u0004C\u0001\u001d\u0001\u001b\u00059\u0001\"B\u0012\u0004\u0001\u0004!\u0003\"\u0002\u0016\u0004\u0001\u0004Y\u0003FA\u0002=!\ti\u0004*D\u0001?\u0015\ty\u0004)\u0001\u0006b]:|G/\u0019;j_:T!!\u0011\"\u0002\u000f\u0019\f7\r^8ss*\u00111\tR\u0001\u0006E\u0016\fgn\u001d\u0006\u0003\u000b\u001a\u000bqb\u001d9sS:<gM]1nK^|'o\u001b\u0006\u0002\u000f\u0006\u0019qN]4\n\u0005%s$!C!vi><\u0018N]3e\u00039)\bo\u001a:bI\u00164VM]:j_:$\u0012\u0001\u0014\t\u0003\u001bVk\u0011A\u0014\u0006\u00031=S!\u0001U)\u0002\u0007\u0005\u0004\u0018N\u0003\u0002S'\u000611/\u001a:wKJT!\u0001V\u0007\u0002\u0011\u0011,\u0007\u000f\\8zSRL!A\u0016(\u0003\u000fY+'o]5p]\u0006IAm\\+qOJ\fG-\u001a\u000b\u00023B\u0011!,X\u0007\u00027*\tA,A\u0003tG\u0006d\u0017-\u0003\u0002_7\n9!i\\8mK\u0006t\u0007")
public class XLRelease1010SmtpServerUpgrader
extends BaseInitializingUpgrade
implements Logging {
    private final ConfigurationRepository configurationRepository;
    private final ConfigurationPersistence configurationPersistence;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        XLRelease1010SmtpServerUpgrader xLRelease1010SmtpServerUpgrader = this;
        synchronized (xLRelease1010SmtpServerUpgrader) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Version upgradeVersion() {
        return Version.valueOf((String)"xl-release", (String)"10.1.0#3");
    }

    public boolean doUpgrade() {
        if (this.configurationRepository.exists(SmtpServer$.MODULE$.SMTP_SERVER_ID())) {
            this.logger().info((Function0 & Serializable)() -> "Found SMTP configuration. It will be upgraded.");
            try {
                SmtpAuthentication smtpAuthentication;
                String smtpServerData = (String)((Tuple3)Option$.MODULE$.option2Iterable(this.configurationPersistence.findById(SmtpServer$.MODULE$.SMTP_SERVER_ID())).head())._2();
                JSONObject smtpServerJson = new JSONObject(smtpServerData);
                SmtpServer smtpServer = new SmtpServer();
                smtpServer.setHost(smtpServerJson.getString("host"));
                smtpServer.setPort(smtpServerJson.getInt("port"));
                smtpServer.setTls(smtpServerJson.getBoolean("tls"));
                smtpServer.setFromAddress(smtpServerJson.getString("fromAddress"));
                if (smtpServerJson.has("testAddress")) {
                    smtpServer.setTestAddress(smtpServerJson.getString("testAddress"));
                }
                if (smtpServerJson.has("username") && !Strings.isNullOrEmpty((String)smtpServerJson.getString("username"))) {
                    String username = smtpServerJson.getString("username");
                    String password = smtpServerJson.has("password") ? smtpServerJson.getString("password") : PasswordEncrypter.getInstance().ensureEncrypted("");
                    BasicSmtpAuthentication basicSmtpAuthentication = new BasicSmtpAuthentication();
                    basicSmtpAuthentication.setUsername(username);
                    basicSmtpAuthentication.setPassword(password);
                    smtpAuthentication = basicSmtpAuthentication;
                } else {
                    smtpAuthentication = new NoSmtpAuthentication();
                }
                NoSmtpAuthentication authentication = smtpAuthentication;
                smtpServer.setAuthentication(authentication);
                smtpServer.setId(SmtpServer$.MODULE$.SMTP_SERVER_ID());
                CiHelper.fixUpInternalReferences((ConfigurationItem)smtpServer);
                v1 = this.configurationRepository.update((BaseConfiguration)smtpServer);
            }
            catch (Exception e) {
                this.logger().error((Function0 & Serializable)() -> "Unable to upgrade SMTP configuration", (Function0 & Serializable)() -> e);
                v1 = BoxedUnit.UNIT;
            }
        } else {
            v1 = BoxedUnit.UNIT;
        }
        return true;
    }

    @Autowired
    public XLRelease1010SmtpServerUpgrader(ConfigurationRepository configurationRepository, ConfigurationPersistence configurationPersistence) {
        this.configurationRepository = configurationRepository;
        this.configurationPersistence = configurationPersistence;
        Logging.$init$((Logging)this);
    }
}

