/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import org.kohsuke.github.GHCommit;
import org.kohsuke.github.GHCommitFilesPage;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GitHubPageIterator;
import org.kohsuke.github.GitHubRequest;
import org.kohsuke.github.PagedIterable;
import org.kohsuke.github.PagedIterator;
import org.kohsuke.github.Requester;

class GHCommitFileIterable
extends PagedIterable<GHCommit.File> {
    private static final int GH_FILE_LIMIT_PER_COMMIT_PAGE = 300;
    private final GHRepository owner;
    private final String sha;
    private final GHCommit.File[] files;

    public GHCommitFileIterable(GHRepository owner, String sha, List<GHCommit.File> files) {
        this.owner = owner;
        this.sha = sha;
        this.files = files != null ? files.toArray(new GHCommit.File[0]) : null;
    }

    @Override
    @Nonnull
    public PagedIterator<GHCommit.File> _iterator(int pageSize) {
        Iterator<GHCommit.File[]> pageIterator;
        if (this.files != null && this.files.length < 300) {
            pageIterator = Collections.singleton(this.files).iterator();
        } else {
            pageSize = 0;
            GitHubRequest request = ((Requester)this.owner.root().createRequest().withUrlPath(this.owner.getApiTailUrl("commits/" + this.sha), new String[0])).build();
            pageIterator = this.adapt(GitHubPageIterator.create(this.owner.root().getClient(), GHCommitFilesPage.class, request, pageSize));
        }
        return new PagedIterator<GHCommit.File>(pageIterator, null);
    }

    protected Iterator<GHCommit.File[]> adapt(final Iterator<GHCommitFilesPage> base) {
        return new Iterator<GHCommit.File[]>(){

            @Override
            public boolean hasNext() {
                return base.hasNext();
            }

            @Override
            public GHCommit.File[] next() {
                GHCommitFilesPage v = (GHCommitFilesPage)base.next();
                return v.getFiles();
            }
        };
    }
}

