/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import java.io.IOException;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import javax.annotation.Nonnull;
import org.jetbrains.annotations.NotNull;
import org.kohsuke.github.GitHubConnectorResponseErrorHandler;
import org.kohsuke.github.HttpException;
import org.kohsuke.github.connector.GitHubConnectorResponse;

public abstract class GitHubRateLimitHandler
extends GitHubConnectorResponseErrorHandler {
    private static final int MINIMUM_RATE_LIMIT_RETRY_MILLIS = 1000;
    public static final GitHubRateLimitHandler WAIT = new GitHubRateLimitHandler(){

        @Override
        public void onError(GitHubConnectorResponse connectorResponse) throws IOException {
            1.sleep(this.parseWaitTime(connectorResponse));
        }
    };
    public static final GitHubRateLimitHandler FAIL = new GitHubRateLimitHandler(){

        @Override
        public void onError(GitHubConnectorResponse connectorResponse) throws IOException {
            throw new HttpException("API rate limit reached", connectorResponse.statusCode(), connectorResponse.header("Status"), connectorResponse.request().url().toString()).withResponseHeaderFields(connectorResponse.allHeaders());
        }
    };

    @Override
    boolean isError(@NotNull GitHubConnectorResponse connectorResponse) throws IOException {
        return connectorResponse.statusCode() == 403 && "0".equals(connectorResponse.header("X-RateLimit-Remaining"));
    }

    @Override
    public abstract void onError(@Nonnull GitHubConnectorResponse var1) throws IOException;

    long parseWaitTime(GitHubConnectorResponse connectorResponse) {
        String v = connectorResponse.header("X-RateLimit-Reset");
        if (v == null) {
            return Duration.ofMinutes(1L).toMillis();
        }
        String dateField = connectorResponse.header("Date");
        ZonedDateTime now = dateField != null ? ZonedDateTime.parse(dateField, DateTimeFormatter.RFC_1123_DATE_TIME) : ZonedDateTime.now();
        return Math.max(1000L, (Long.parseLong(v) - now.toInstant().getEpochSecond()) * 1000L);
    }
}

