/*
 * Decompiled with CFR 0.152.
 */
package com.versionone.apiclient.services;

import com.versionone.apiclient.interfaces.IAttributeDefinition;
import com.versionone.apiclient.services.TextBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class OrderBy {
    List<Term> _terms = new ArrayList<Term>();

    public List<Term> getTerms() {
        return (List)Collections.unmodifiableCollection(this._terms);
    }

    public void majorSort(IAttributeDefinition attribdef, Order order) {
        this.remove(attribdef);
        this._terms.add(0, new Term(attribdef, order));
    }

    public void minorSort(IAttributeDefinition attribdef, Order order) {
        this.remove(attribdef);
        this._terms.add(new Term(attribdef, order));
    }

    public int size() {
        return this._terms.size();
    }

    public String getToken() {
        return TextBuilder.join(this._terms, ",");
    }

    public String toString() {
        return this.getToken();
    }

    private void remove(IAttributeDefinition attribdef) {
        int index = this.indexOf(attribdef);
        if (index == -1) {
            return;
        }
        this._terms.remove(index);
    }

    private int indexOf(IAttributeDefinition attribdef) {
        for (int i = 0; i < this._terms.size(); ++i) {
            if (this._terms.get(i).getAttributeDefinition() != attribdef) continue;
            return i;
        }
        return -1;
    }

    class Term {
        private IAttributeDefinition AttributeDefinition;
        private Order Order;

        public IAttributeDefinition getAttributeDefinition() {
            return this.AttributeDefinition;
        }

        public Order getOrder() {
            return this.Order;
        }

        public Term(IAttributeDefinition attribdef, Order order) {
            this.AttributeDefinition = attribdef;
            this.Order = order;
        }

        public String getToken() {
            StringBuffer token = new StringBuffer();
            if (this.Order != com.versionone.apiclient.services.OrderBy$Order.Ascending) {
                token.append("-");
            }
            token.append(this.AttributeDefinition.getToken());
            return token.toString();
        }

        public String toString() {
            return this.getToken();
        }
    }

    public static enum Order {
        Ascending,
        Descending;

    }
}

