/*
 * Decompiled with CFR 0.152.
 */
package com.versionone.apiclient.services;

import com.versionone.utils.Delegator;
import com.versionone.utils.IDelegate;
import java.util.List;

public class TextBuilder {
    private static final Class[] PARAMETERS = new Class[]{Object.class};
    public static final Delegator STRINGIZER_DELEGATE = new Delegator(PARAMETERS, String.class);

    public static void splitPrefix(String source, char separator, StringBuffer prefix, StringBuffer suffix) {
        String sep = separator == '.' ? "\\." : String.valueOf(separator);
        String[] parts = source.split(sep, 2);
        if (parts.length == 1) {
            prefix.replace(0, prefix.length(), "");
            suffix.replace(0, suffix.length(), parts[0]);
        } else {
            prefix.replace(0, prefix.length(), parts[0]);
            suffix.replace(0, suffix.length(), parts[1]);
        }
    }

    public static String join(Object[] pathParts, String seperator) {
        return TextBuilder.join(pathParts, seperator, STRINGIZER_DELEGATE.build(DefaultStringize.class, "toString"));
    }

    public static String join(Object[] pathParts, String seperator, IDelegate stringize) {
        StringBuffer rc = new StringBuffer();
        boolean useSeperator = false;
        for (Object value : pathParts) {
            if (useSeperator) {
                rc.append(seperator);
            } else {
                useSeperator = true;
            }
            try {
                rc.append(stringize.invoke(value));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return rc.toString();
    }

    public static String join(List pathParts, String seperator) {
        return TextBuilder.join(pathParts.toArray(), seperator);
    }

    public static String join(List pathParts, String seperator, IDelegate stringize) {
        return TextBuilder.join(pathParts.toArray(), seperator, stringize);
    }

    public static class DefaultStringize {
        public static String toString(Object value) {
            return value == null ? "" : value.toString();
        }
    }
}

