/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.concurrent;

import java.security.AccessController;

class SecurityActions {
    SecurityActions() {
    }

    static int getCoreThreads(String name) {
        String value = SecurityActions.getSystemProperty(name);
        if (value == null) {
            return Math.max(5, Runtime.getRuntime().availableProcessors());
        }
        return Integer.parseInt(value);
    }

    static void registerShutdownHook(Thread hook) {
        if (System.getSecurityManager() == null) {
            Runtime.getRuntime().addShutdownHook(hook);
        } else {
            AccessController.doPrivileged(() -> {
                Runtime.getRuntime().addShutdownHook(hook);
                return null;
            });
        }
    }

    static void removeShutdownHook(Thread hook) {
        if (System.getSecurityManager() == null) {
            Runtime.getRuntime().removeShutdownHook(hook);
        } else {
            AccessController.doPrivileged(() -> {
                Runtime.getRuntime().removeShutdownHook(hook);
                return null;
            });
        }
    }

    private static String getSystemProperty(String name) {
        if (System.getSecurityManager() == null) {
            return System.getProperty(name);
        }
        return AccessController.doPrivileged(() -> System.getProperty(name));
    }
}

