/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.plugin.platform.connector;

import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.xlrelease.plugin.platform.connector.HttpClientWrapper;
import com.xebialabs.xlrelease.plugin.platform.connector.LoggerResponseErrorHandler$;
import com.xebialabs.xlrelease.plugin.platform.connector.ProxyConfiguration;
import com.xebialabs.xlrelease.plugin.platform.connector.ServerConfiguration;
import java.util.concurrent.TimeUnit;
import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.config.ConnectionConfig;
import org.apache.hc.client5.http.impl.auth.BasicCredentialsProvider;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.io.BasicHttpClientConnectionManager;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.core5.http.HttpHost;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestTemplate;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.runtime.BoxedUnit;

public final class HttpClientWrapper$ {
    public static final HttpClientWrapper$ MODULE$ = new HttpClientWrapper$();

    public HttpClientWrapper apply(ServerConfiguration configuration) {
        return new HttpClientWrapper(configuration.url(), this.restTemplate(configuration)).withAuth(configuration);
    }

    private RestTemplate restTemplate(ServerConfiguration serverConfiguration) {
        CloseableHttpClient httpClient = this.getDefaultClient(serverConfiguration);
        HttpComponentsClientHttpRequestFactory httpComponentsClientHttpRequestFactory = new HttpComponentsClientHttpRequestFactory((HttpClient)httpClient);
        RestTemplate restTemplate = new RestTemplate((ClientHttpRequestFactory)httpComponentsClientHttpRequestFactory);
        restTemplate.setErrorHandler((ResponseErrorHandler)LoggerResponseErrorHandler$.MODULE$);
        return restTemplate;
    }

    public CloseableHttpClient getDefaultClient(ServerConfiguration serverConfiguration) {
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
        if (serverConfiguration.proxyConfiguration() != null) {
            ProxyConfiguration proxyConfig = serverConfiguration.proxyConfiguration();
            String proxyHost = proxyConfig.host();
            String proxyPort = proxyConfig.port();
            if (Strings.isNotBlank((String)proxyHost) && Strings.isNotBlank((String)proxyPort)) {
                HttpHost proxy = new HttpHost(proxyHost, StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(proxyPort)));
                v0 = httpClientBuilder.setProxy(proxy);
            } else {
                v0 = BoxedUnit.UNIT;
            }
            String proxyUsername = proxyConfig.username();
            String proxyPassword = proxyConfig.password();
            if (Strings.isNotBlank((String)proxyUsername) && Strings.isNotBlank((String)proxyPassword)) {
                BasicCredentialsProvider credentialProvider = new BasicCredentialsProvider();
                credentialProvider.setCredentials(new AuthScope(proxyHost, StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(proxyPort))), (Credentials)new UsernamePasswordCredentials(proxyUsername, proxyPassword.toCharArray()));
                v1 = httpClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credentialProvider);
            } else {
                v1 = BoxedUnit.UNIT;
            }
        } else {
            v1 = BoxedUnit.UNIT;
        }
        int connectionTimeout = serverConfiguration.connectionConfiguration().timeout();
        BasicHttpClientConnectionManager cm = new BasicHttpClientConnectionManager();
        cm.setConnectionConfig(ConnectionConfig.custom().setSocketTimeout(connectionTimeout, TimeUnit.SECONDS).build());
        httpClientBuilder.setConnectionManager((HttpClientConnectionManager)cm);
        httpClientBuilder.disableCookieManagement();
        return httpClientBuilder.build();
    }

    public <T> HttpClientWrapper.ResponseEntityExtension<T> ResponseEntityExtension(ResponseEntity<T> response) {
        return new HttpClientWrapper.ResponseEntityExtension<T>(response);
    }

    private HttpClientWrapper$() {
    }
}

