import { deliveryTasks, initialState } from './delivery-tasks.reducer';

const { loadDeliveryOrPattern, searchDeliveriesOrPatterns, setDeliveryOrPattern, setDeliveriesOrPatterns, searchPatterns, setPatterns } = deliveryTasks.actions;

describe('deliveryTasks reducer', () => {
    it('should have the initial state', () => {
        expect(deliveryTasks.name).toBe('deliveryTasks');
        expect(deliveryTasks.getInitialState()).toBe(initialState);
    });
    describe('loadDeliveryOrPattern', () => {
        it('should do nothing with the state', () => {
            const state = deliveryTasks.reducer(initialState, loadDeliveryOrPattern({ isDelivery: true, id: 'myid' }));
            expect(state).toBe(initialState);
        });
    });
    describe('searchDeliveriesOrPatterns', () => {
        it('should do nothing with the state', () => {
            const state = deliveryTasks.reducer(initialState, searchDeliveriesOrPatterns({ isDelivery: true }));
            expect(state).toBe(initialState);
        });
    });
    describe('searchPatterns', () => {
        it('should do nothing with the state', () => {
            const state = deliveryTasks.reducer(initialState, searchPatterns());
            expect(state).toBe(initialState);
        });
    });
    describe('setDeliveryOrPattern', () => {
        it('should update the state', () => {
            const state = deliveryTasks.reducer(initialState, setDeliveryOrPattern({ id: 'MyDelivery' } as never));
            expect(state.deliveryOrPattern?.id).toBe('MyDelivery');
        });
    });
    describe('setDeliveriesOrPatterns', () => {
        it('should update the state', () => {
            const state = deliveryTasks.reducer(initialState, setDeliveriesOrPatterns([{ id: 'MyDelivery' }] as never));
            expect(state.deliveriesOrPatterns).toHaveLength(1);
        });
    });
    describe('setPatterns', () => {
        it('should update the state', () => {
            const state = deliveryTasks.reducer(initialState, setPatterns([{ id: 'MyPattern' }] as never));
            expect(state.patterns).toHaveLength(1);
        });
    });
});
