#
# Copyright (c) 2023. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#
import requests
import tempfile
import zipfile
import io
import os
from opa.parseAppwareJsonLog import AppwareJsonParser

androidfilename = '3_Print android ProtectionManifest.txt'
iosfilename = '3_Print IOS ProtectionManifest.txt'

if applicationType == "Ios":
    filename = iosfilename
else:
    filename = androidfilename

print("Downloading logs from Github action run")
url = '%s/repos/%s/%s/actions/runs/%s/logs' % (baseUrl, username, repositoryName, runId)
headers = {'Authorization': 'token %s' % gitPAT, 'Accept': 'application/vnd.github+json'}
try:
    response = requests.get(url,  headers=headers, verify=False)
except RequestException as e:
    print(e)
    raise Exception("Error downloading logs from Github Action run")

download_dir = tempfile.mkdtemp()
z = zipfile.ZipFile(io.BytesIO(response.content))
z.extractall(download_dir)

logLocation = os.path.join(download_dir,'build',filename)
print("Downloaded logs to %s" % logLocation)
jsonInput = AppwareJsonParser(logLocation).parse()