#
# Copyright (c) 2018. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#

from com.xebialabs.overthere import Overthere, ConnectionOptions

def configure(configuration, isJumpstation = False):
    options = ConnectionOptions()
    options.set("address", configuration.address)
    options.set("port", configuration.port)
    if configuration.hasProperty("username") and configuration.username and len(configuration.username) > 0:
        options.set("username", configuration.username)
    if configuration.hasProperty("password") and configuration.password and len(configuration.password) > 0:
        options.set("password", configuration.password)
    if configuration.hasProperty("passphrase") and configuration.passphrase and len(configuration.passphrase) > 0:
        options.set("passphrase", configuration.passphrase)
    if configuration.hasProperty("privateKeyFile") and configuration.privateKeyFile and len(configuration.privateKeyFile) > 0:
        options.set("privateKeyFile", configuration.privateKeyFile)
    if configuration.hasProperty("privateKey") and configuration.privateKey and len(configuration.privateKey) > 0:
        options.set("privateKey", configuration.privateKey)
    options.set("os", str(configuration.os))
    options.set("tmp", configuration.temporaryDirectoryPath)
    options.set("protocol", configuration.protocol)

    if not isJumpstation:
        options.set("connectionType", str(configuration.connectionType))
        options.set("sudoUsername", configuration.sudoUsername)
        options.set("suUsername", configuration.sudoUsername)
        options.set("suPassword", configuration.sudoUsername)

    if configuration.hasProperty('jumpstation') and configuration.jumpstation:
        options.set("jumpstation", configure(configuration.jumpstation, True))

    return options


options = configure(configuration)

connection = Overthere.getConnection("ssh", options)

