#
# Copyright (c) 2018. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#

from xlropenshift.api_client import APIClient

client = APIClient(task.pythonScript.getProperty("client"))

try:
    response = client.execute_openshift_command(
        command="{} dc/{}".format(task.pythonScript.getProperty('command'), task.pythonScript.getProperty('deploymentConfName')),
        cmd_params=task.pythonScript.getProperty('cmdParams'), process_exit = False).stdout

    if 'rolled out' not in response:
        raise RuntimeError("Triggering {} deployment failed.".format(task.pythonScript.getProperty('deploymentConfName')))

    output = client.execute_openshift_command(
        command="rollout status dc/{}".format(task.pythonScript.getProperty('deploymentConfName')), process_exit = False).stdout

    if not output.endswith("successfully rolled out"):
        raise RuntimeError("Deployment {} failed.".format(task.pythonScript.getProperty('deploymentConfName')))
finally:
    client.logout()