#
# Copyright (c) 2018. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#
from xlropenshift.client.openshift_client import OpenShiftClient
from urlparse import urlparse
import requests

client = OpenShiftClient(server)

# OpenShift dynamic client
test_dyn_client = client.dyn_client()

# Returning a ResourceInstance object
v1_services = test_dyn_client.resources.get(api_version='v1', kind='Service')

# Accessing specific service
service = v1_services.get(name=serviceName, namespace=projectName)

def create_url(openshift_url, port, path_url):
    parsed = urlparse(openshift_url)
    return parsed._replace(netloc="{}:{}".format(parsed.hostname, port), scheme='http', path=path_url).geturl()

node_port_found = False
if service.spec and service.spec.ports:
    for port in service.spec.ports:
        if port.nodePort:
            node_port_found = True
            url = create_url(server['serverUrl'], port.nodePort, healthCheckUrl)
            print "Checking health url for {}".format(url)
            requests.get(url=url)
if not node_port_found:
    raise RuntimeError('node port not found in service')