#
# Copyright (c) 2019. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries and licensors.
#

import sys
from org.apache.http.client import ClientProtocolException
from xlrelease.HttpRequest import HttpRequest

params = {'url': configuration.url, 'username': configuration.username, 'password': configuration.password,
          'proxyHost': configuration.proxyHost, 'proxyPort': configuration.proxyPort,
          'proxyUsername': configuration.proxyUsername, 'proxyPassword': configuration.proxyPassword, 'proxyDomain': configuration.proxyDomain}

path = "api/v1/projectVersions?fields=id&limit=1"
if hasattr(configuration, 'checkConfigurationContentType') and configuration.checkConfigurationContentType:
    contentType = configuration.checkConfigurationContentType
else:
    contentType = None

headers_fortify_token = {}

logger.info("=== Fortify SSC CHECK CONNECTION ==========================================")

if configuration.authenticationMethod == "PAT":
    logger.info("PAT authentication Method")
    if configuration.password:
        headers_fortify_token = {
            "Authorization": "FortifyToken {}".format(configuration.password)
        }
    else:
        print("Token Not given, Please enter the Token.")

response = None

try:
    if headers_fortify_token is not None:
        params.pop('username')
        params.pop('password')
    http_request = HttpRequest(params)
    response = http_request.get(path, headers=headers_fortify_token)
except ClientProtocolException:
    raise Exception("URL is not valid")

if not response.isSuccessful():
    reason = "Unknown"
    if response.status == 400:
        reason = "Bad request"
    elif response.status == 401:
        reason = "Unauthorized"
    elif response.status == 403:
        reason = "Forbidden"
    raise Exception("HTTP response code %s (%s)" % (response.status, reason))

logger.info("=== Fortify SSC CHECK CONNECTION Successful================================")
