#
# Copyright (c) 2019. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries and licensors.
#

from fortify import FortifyService

global fortifyServer, projectName, projectVersion, metrics

# Validate properties
missedProperties = []

if not fortifyServer:
    missedProperties.append('Fortify server')
if not projectName:
    missedProperties.append('Application name')
if not projectVersion:
    missedProperties.append('Project version')
if not metrics:
    missedProperties.append('Metrics')

if missedProperties:
    raise Exception("{} must be provided".format(', '.join(missedProperties)))

RANGE_SUFFIX = {
    'integer': '',
    'percent': '%',
    'default': ''
}

project_versions = FortifyService.get_project_versions(fortifyServer, project_name=projectName, fields=['id', 'name', 'currentState'])
project = None
for project_version in project_versions.get('data'):
    if project_version.get('name') == projectVersion:
        project = project_version
        break

data = []
if project:
    metrics_data = FortifyService.get_fortify_performance_indicator_histories(fortify_server=fortifyServer, version_id=project.get('id'))

    data = {
        'versionId': project.get('id'),
        'projectName': projectName,
        'fortifyUrl': fortifyServer['url'].strip('/'),
        'projectVersion': projectVersion,
        'lastAnalysisDate': project.get('currentState').get('metricEvaluationDate')
    }

    included_data = set(metrics.keys())
    for result in metrics_data:
        if result.get('id') in included_data:
            range_type = result.get('range', 'default')
            formatter = '%d%s' if range_type == 'integer' else '%s%s'
            data[result.get('id')] =  formatter % (result.get('value'), RANGE_SUFFIX[range_type])
