#
# Copyright (c) 2019. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries and licensors.
#

import java
import yaml
import datetime

from fortify import FortifyService

FORTIFY_SECURITY_RATING = 'FortifySecurityRating'
createDate = datetime.datetime.now()

def compare_data(compliance_data, threshold_data):
    for key in threshold_data:
        if key=='Fortify Security Rating':
            if compliance_data[key] < threshold_data[key]:
                return False
        else:
            if compliance_data[key] > threshold_data[key]:
                return False
    return True

def print_data(compliance_data, threshold_data):
    rating_key = 'Fortify Security Rating'
    minimum = threshold_data[rating_key]
    value = compliance_data[rating_key]
    status = "Pass" if value >= minimum else "Fail"
    print("Fortify Security Rating : Minimum - {}, Value - {}, Status - {}\n".format(minimum, value, status))
    for key in threshold_data:
        if key!=rating_key:
            value = compliance_data[key]
            threshold = threshold_data[key]
            status = "Pass" if value <= threshold else "Fail"
            print("{} : Threshold - {}, Value - {}, Status - {} \n".format(key, threshold, value, status))

def convert_to_datetime(from_date):
    sdf = java.text.SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ")
    return sdf.parse(from_date)


def add_code_compliance_record(outcome=None, compliance_data=None, analysis_date_str=None, project_url=None):
    try:
        #analysis_date = convert_to_datetime(analysis_date_str)
        record = taskReportingApi.newCodeComplianceRecord()
        record.targetId = task.id
        record.serverUrl = fortifyServer['url']
        record.serverUser = fortifyServer['username']
        record.project = projectName
        record.outcome = outcome
        record.complianceData = yaml.dump(compliance_data, default_flow_style=False)
        record.analysisDate = analysis_date_str
        record.project_url = project_url
        taskReportingApi.addRecord(record, True)
    except:
        exctype, value = sys.exc_info()[:2]
        print("{} occurred while creating `udm.CodeComplianceRecord` - {}".format(exctype, value))


if not fortifyServer:
    add_code_compliance_record()
    raise Exception("Fortify server ID must be provided")

project_versions = FortifyService.get_project_versions(fortifyServer, project_name=projectName)

project = None
for project_version in project_versions.get('data'):
    if project_version.get('name') == projectVersion:
        project = project_version
        break

if project is None:
    add_code_compliance_record()
    raise Exception("Project with name '{}' and version '{}' not found".format(projectName, projectVersion))

rating = FortifyService.get_fortify_performance_indicator_histories(fortifyServer, version_id=project.get('id'),
                                                                    indicator=FORTIFY_SECURITY_RATING)

threshold_data = {"Fortify Security Rating": minimumStarRating, "Critical Issues": criticalThreshold, "High Issues": highThreshold, "Medium Issues": mediumThreshold, "Low Issues": lowThreshold}

compliance_data = {"Fortify Security Rating": rating['value']}

metrics = {"Total Issues": None, "Critical Issues": "critical", "High Issues": "high", "Medium Issues": "medium",
           "Low Issues": "low"}

for key, value in metrics.iteritems():
    compliance_data[str(key)] = FortifyService.get_issues_count(fortify_server=fortifyServer,
                                                               version_id=project.get('id'),
                                                               issue_type=value)

compare_result = compare_data(compliance_data, threshold_data)

add_code_compliance_record(outcome=("PASSED" if compare_result else "FAILED"),
                          analysis_date_str=rating.get('timestamp'),
                          compliance_data=compliance_data,
                          project_url='{}/html/ssc/version/{}/overview'.format(fortifyServer.get('url').strip('/'),
                                                                              project.get('id')))

print "Analysis Date and Time: {}\n".format(rating['timestamp'])
analysisDate = rating.get('timestamp')
print_data(compliance_data, threshold_data)

if compare_result:
    print "Code compliance checks verified."
else:
    raise Exception("Code compliance check(s) failed")
