import React from 'react';
import { mount } from 'enzyme';
import { MenuItem } from './menu-item.component';
import { DotIconWrapper } from '../../../features/common/components/dot-icon-wrapper/dot-icon-wrapper';

describe('MenuItem', () => {
    it('should render label', () => {
        const wrapper = mount(<MenuItem label="Duplicate" />);
        expect(wrapper.exists()).toBeTruthy();
        expect(wrapper.contains('Duplicate')).toBeTruthy();
        expect(wrapper.find(`DotIconWrapper`).exists()).toBeFalsy();
    });

    it('should render icon', () => {
        const wrapper = mount(<MenuItem iconId="duplicate" label="Duplicate" />);
        expect(wrapper.exists()).toBeTruthy();
        expect(wrapper.contains('Duplicate')).toBeTruthy();
        expect(wrapper.find(`DotIconWrapper`).exists()).toBeTruthy();
        expect(wrapper.find(`DotIconWrapper`).prop('iconId')).toBe('duplicate');
    });

    it('should render end icon', () => {
        const wrapper = mount(<MenuItem endIconId="open-new-tab" iconId="duplicate" label="Duplicate" />);
        const icons = wrapper.find(DotIconWrapper);
        expect(icons.length).toBe(2);
        expect(icons.at(0).props().iconId).toBe('duplicate');
        expect(icons.at(1).props().iconId).toBe('open-new-tab');
    });
});
