import { initialState, remoteRunners } from './remote-runners.reducer';
import { remoteRunnerMock } from '../__mocks__/remote-runners.mocks';

describe('remote runners reducer', () => {
    const { setIsLoading, loadRemoteRunners, setRemoteRunners, reloadRemoteRunners, updateRemoteRunnerState, deleteRemoteRunner } = remoteRunners.actions;

    it('should have the initial state', () => {
        expect(remoteRunners.name).toBe('remoteRunners');
        expect(remoteRunners.reducer(undefined, { type: 'default' })).toBe(initialState);
    });

    describe('reducers', () => {
        describe('setIsLoading', () => {
            it('should set isLoading', () => {
                const state = remoteRunners.reducer(initialState, setIsLoading(true));
                expect(state.isLoading).toStrictEqual(true);
            });
        });
        describe('loadRemoteRunners', () => {
            it('should not update state', () => {
                const state = remoteRunners.reducer(initialState, loadRemoteRunners());
                expect(state).toStrictEqual(initialState);
            });
        });
        describe('setRemoteRunners', () => {
            const runners = [remoteRunnerMock];
            it('should set remote runners', () => {
                const state = remoteRunners.reducer(initialState, setRemoteRunners(runners));
                expect(state.remoteRunners).toStrictEqual(runners);
            });
        });
        describe('reloadRemoteRunners', () => {
            it('should not update state', () => {
                const payload = {
                    id: '',
                    isUpdate: false,
                };
                const state = remoteRunners.reducer(initialState, reloadRemoteRunners(payload));
                expect(state).toStrictEqual(initialState);
            });
        });
        describe('updateRemoteRunnerState', () => {
            const payload = {
                id: remoteRunnerMock.id,
                enable: false,
            };
            it('should not update state', () => {
                const state = remoteRunners.reducer(initialState, updateRemoteRunnerState(payload));
                expect(state).toStrictEqual(initialState);
            });
        });
        describe('deleteRemoteRunner', () => {
            it('should not update state', () => {
                const state = remoteRunners.reducer(initialState, deleteRemoteRunner(remoteRunnerMock));
                expect(state).toStrictEqual(initialState);
            });
        });
    });
});
