import React from 'react';
import { DotLink, DotTooltip, DotTypography } from '@digital-ai/dot-components';
import { getDeliveryUrlFromPath, getTargetTypeLabel } from '../../helper';
import { ActivityLogsContainerEnum } from '../../types';

export interface ActivityLogsTypeDeliveryProps {
    targetId: string | null;
    targetType: string | null;
}

export const ActivityLogsTypeDelivery = ({ targetId, targetType }: ActivityLogsTypeDeliveryProps) => {
    if (!targetId || !targetType) {
        return (
            <DotTypography data-testid="type-label-typography" variant="body1">
                <DotTooltip
                    placement="left"
                    title="Link is unavailable because the target item cannot be identified or referenced for deliveries older than version 9.0.0."
                >
                    <>Not available</>
                </DotTooltip>
            </DotTypography>
        );
    }

    return targetType === 'delivery.Delivery' ? (
        <DotLink href={getDeliveryUrlFromPath(targetId)}>Delivery</DotLink>
    ) : (
        <DotTypography data-testid="type-label-typography" variant="body1">
            {getTargetTypeLabel(targetType, ActivityLogsContainerEnum.DELIVERY)}
        </DotTypography>
    );
};
