import { User } from '@xlr-ui/app/types';

export interface ActivityLogsFilterSettings {
    activityTypes: string[];
    comments: boolean;
    dateAsc: boolean;
    deliveryEdit: boolean;
    execution: boolean;
    filter: string;
    folderId: string | null;
    from: number | null;
    isImportantHighlighted: boolean;
    lifecycle: boolean;
    other: boolean;
    reassign: boolean;
    releaseEdit: boolean;
    reportingRecordEdit: boolean;
    security: boolean;
    targetId?: string;
    taskEdit: boolean;
    to: number | null;
    triggerEdit: boolean;
    usernames: string[];
}

export interface ActivityLog {
    activityType: string;
    dataId: string | null;
    eventTime: number;
    message: string;
    targetId: string | null;
    targetType: string | null;
    user: User;
}

export type ActivityLogGroupType = Record<string, ActivityLog[]>;

export interface ActivityTypePillProps {
    background: string;
    border: string;
    label: string;
}
