#
# Copyright (c) 2019. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#

import re
from java.lang import Exception, String
from sonar import SonarApiService

def check_sonar_response(sonar_response):
    if sonar_response.get('error'):
        raise Exception('\n'.join(e['msg'] for e in sonar_response.get('error')))

def filter_version_events(sonar_response):
    check_sonar_response(sonar_response)
    filtered_data = []
    for analysis in sonar_response.get('analyses'):
        for event in analysis.get('events'):
            if event.get('category') == 'VERSION':
                if re.search(versionFilterRegex, event.get('name'), flags=re.IGNORECASE) is not None:
                    version = {
                        'date': analysis.get('date'),
                        'name': event.get('name')
                    }
                    filtered_data.append(version)
    return filtered_data

def filter_search_history(sonar_response):
    check_sonar_response(sonar_response)
    filtered_data = []
    for measure in sonar_response.get('measures'):
        for measure_value in measure.get('history'):
            if measure_value.get('value') is not None:
                metric = {
                    'name': measure.get('metric'),
                    'value': measure_value.get('value'),
                    'date': measure_value.get('date')
                }
                filtered_data.append(metric)
    return filtered_data


# Validate properties
missedProperties = []

if not sonarServer:
    missedProperties.append('Sonar server')
if not timeFrame:
    missedProperties.append('Time frame')
if not resource:
    missedProperties.append('Project')
if not metrics:
    missedProperties.append('Metrics')

try:
    if missedProperties:
        raise Exception("{} must be provided".format(', '.join(missedProperties)))

    date_to_str = SonarApiService.format_sonar_api_date(timeFrame.getEndDate(dateTo))
    date_from_str = SonarApiService.format_sonar_api_date(timeFrame.getStartDate(dateFrom))

    versions = SonarApiService.paginate_sonar_request(
        lambda page: SonarApiService.get_project_analyses(sonarServer, date_from_str, date_to_str, resource, page),
        lambda sonar_response: filter_version_events(sonar_response)
    )

    history = SonarApiService.paginate_sonar_request(
        lambda page: SonarApiService.get_search_history(sonarServer, date_from_str, date_to_str, resource, metrics, page),
        lambda sonar_response: filter_search_history(sonar_response)
    )

    baseUrl = sonarServer.get('url')

    sonarProjectUrl = "{}{}dashboard?id={}".format(
        baseUrl, '/' if not String(baseUrl).endsWith('/') else '', resource
    )

    data = {
        'versions': versions,
        'history': history,
        'projectUrl': sonarProjectUrl
    }
except Exception as exception:
    data = {
        'error': exception.getMessage()
    }