import { byTitle } from '../../../utils';
import { Environment, EnvironmentEdit, EnvironmentList, EnvironmentName, Stage } from '../../../application-list.types';
import { PayloadAction, createSlice } from '@reduxjs/toolkit';
import noop from 'lodash/noop';

export const initialState: EnvironmentList = {
    environments: [],
    filters: {
        title: '',
        stage: {
            id: '',
            title: '',
        },
    },
    loading: false,
    stages: [],
};

export const environmentLists = createSlice({
    name: 'environmentLists',
    initialState,
    reducers: {
        initEnvironmentList: (_state: EnvironmentList, _action: PayloadAction<string>) => noop(),
        searchEnvironments: (_state: EnvironmentList, _action: PayloadAction<EnvironmentName>) => noop(),
        setLoading: (state: EnvironmentList, action: PayloadAction<boolean>) => {
            state.loading = action.payload;
        },
        setEnvironments: (state: EnvironmentList, action: PayloadAction<Array<Environment>>) => {
            state.environments = action.payload.sort(byTitle);
            state.loading = false;
        },
        setFilterTitle: (state: EnvironmentList, action: PayloadAction<string>) => {
            state.filters.title = action.payload;
        },
        setFilterStage: (state: EnvironmentList, action: PayloadAction<Stage>) => {
            state.filters.stage = action.payload;
        },
        setStages: (state: EnvironmentList, action: PayloadAction<Array<Stage>>) => {
            state.stages = action.payload;
        },
        createEnvironment: (_state: EnvironmentList, _action: PayloadAction<string>) => noop(),
        editEnvironment: (_state: EnvironmentList, _action: PayloadAction<EnvironmentEdit>) => noop(),
        deleteEnvironment: (_state: EnvironmentList, _action: PayloadAction<Environment>) => noop(),
    },
});
