from xlrxldeploy.ci import get_api_client, create_ci, check_ci_exist, get_download_uuid, get_client_config, get_xldeploy_url


source_server = task.getPythonScript().getProperty("server")
destination_server = task.getPythonScript().getProperty("destinationXLDeployServer")


xld_destination_client = get_api_client(destination_server, task, username=destinationUsername, password=destinationPassword)

destination_args=dict(server=destination_server, task=task, username=destinationUsername, password=destinationPassword)


def check_ci_exists_at_path(path):
    data = dict(destination_args)
    data['path'] = path
    return check_ci_exist(**data)


def create_empty_ci_of_type(path, type):
    create_ci_args = destination_args.copy()
    create_ci_args.update(dict(ci_id=path, ci_type=type, ci_xml=None))
    create_ci(**create_ci_args)


def create_path(path):
    parent = path.rpartition('/')[0]
    if parent and not check_ci_exists_at_path(parent):
        create_path(parent)
    create_empty_ci_of_type(path=path, type="core.Directory")


def get_username():
    return username if username else source_server.username


def get_password():
    return password if username else source_server.password


if autoCreatePath:
    app_path = deploymentPackage.rpartition('/')[0]
    if not check_ci_exists_at_path(app_path):
        parent = app_path.rpartition('/')[0]
        if not check_ci_exists_at_path(parent):
            create_path(parent)
        create_app_args = destination_args.copy()
        create_empty_ci_of_type(path=app_path, type="udm.Application")

if check_ci_exists_at_path(deploymentPackage):
    if idempotent:
        xld_destination_client.repository.delete(deploymentPackage)
    else:
        raise Exception("[%s] already exists on destination server!" % deploymentPackage)

package_uuid = get_download_uuid(deploymentPackage, source_server, task=task)

fetch_url = get_xldeploy_url(get_client_config(xld_server=source_server, task=task), '/internal/download/' + package_uuid)
print(fetch_url)
xld_destination_client.package.fetch2(fetch_url, get_username(), get_password())
