from xlrxldeploy import get_api_client
from xlrxldeploy import invoke_task_and_wait_for_undeployment


class Infrastructure(object):
    def __init__(self, task):
        self.__client = get_api_client(task.getPythonScript().getProperty("server"), task)
        self.__task = task

    def undeploy_and_delete(self, ci_id):
        deployed_ids = self.__get_ci_tree(ci_id)
        environments = self.__get_ci_tree('Environments')
        for id in self.__get_ci_ids_to_undeploy(environments, deployed_ids):
            if self.__client.repository.exists(id):
                self.__undeploy(id)
        self.__remove_from_members_list(environments, deployed_ids)
        self.__delete_cis(deployed_ids)

    def __get_ci_ids_to_undeploy(self, environments, deployed_ids):
        deployid_and_envci_list = []
        for environment in environments:
            if self.__client.repository.exists(environment):
                environment_ci = self.__client.repository.read(environment)
                if environment_ci.type == 'udm.DeployedApplication':
                    tmp_list = [{'id': deployed, 'environment': environment_ci} for deployed in environment_ci.deployeds if deployed in deployed_ids]
                    deployid_and_envci_list.extend(tmp_list)
        return [k['environment'].id for k in sorted(deployid_and_envci_list, key=lambda k: k['id'], reverse=True)]

    def __undeploy(self, deployed_application_id):
        print "Undeploying application {} \n".format(deployed_application_id)
        deployment = self.__client.deployment.prepare_undeploy(deployed_application_id)
        xld_task = self.__client.deployment.create_task(deployment)
        invoke_task_and_wait_for_undeployment(self.__task, xld_task.task_id, 10, 24, 100)

    def __remove_from_members_list(self, environments, deployed_ids):
        for environment in environments:
            if self.__client.repository.exists(environment):
                env_ci = self.__client.repository.read(environment)
                if 'members' in env_ci.to_dict():
                    for member in env_ci.members:
                        if member in deployed_ids:
                            print "deleting {} from {}'s members list\n".format(member, env_ci.id)
                            ci = self.__client.repository.read(env_ci.id)
                            ci.members.remove(member)
                            self.__client.repository.update_ci(ci)

    def __delete_cis(self, ci_ids):
        for ci_id in ci_ids:
            if self.__client.repository.exists(ci_id):
                print "deleting {} \n".format(ci_id)
                self.__client.repository.delete(ci_id)

    def __get_ci_tree(self, ci_id):
        result = []
        for ci in self.__client.repository.query('parent={}'.format(ci_id)):
            result.extend(self.__get_ci_tree(ci['ref']))
            result.append(ci['ref'])
        result.append(ci_id)
        return set(result)
